<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipperType StructType
 * @subpackage Structs
 */
class ShipperType extends CompanyInfoType
{
    /**
     * The ShipperNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipperNumber;
    /**
     * The FaxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaxNumber;
    /**
     * The EMailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMailAddress;
    /**
     * The Address
     * @var \StructType\ShipAddressType
     */
    public $Address;
    /**
     * Constructor method for ShipperType
     * @uses ShipperType::setShipperNumber()
     * @uses ShipperType::setFaxNumber()
     * @uses ShipperType::setEMailAddress()
     * @uses ShipperType::setAddress()
     * @param string $shipperNumber
     * @param string $faxNumber
     * @param string $eMailAddress
     * @param \StructType\ShipAddressType $address
     */
    public function __construct($shipperNumber = null, $faxNumber = null, $eMailAddress = null, \StructType\ShipAddressType $address = null)
    {
        $this
            ->setShipperNumber($shipperNumber)
            ->setFaxNumber($faxNumber)
            ->setEMailAddress($eMailAddress)
            ->setAddress($address);
    }
    /**
     * Get ShipperNumber value
     * @return string|null
     */
    public function getShipperNumber()
    {
        return $this->ShipperNumber;
    }
    /**
     * Set ShipperNumber value
     * @param string $shipperNumber
     * @return \StructType\ShipperType
     */
    public function setShipperNumber($shipperNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperNumber) && !is_string($shipperNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperNumber, true), gettype($shipperNumber)), __LINE__);
        }
        $this->ShipperNumber = $shipperNumber;
        return $this;
    }
    /**
     * Get FaxNumber value
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->FaxNumber;
    }
    /**
     * Set FaxNumber value
     * @param string $faxNumber
     * @return \StructType\ShipperType
     */
    public function setFaxNumber($faxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($faxNumber) && !is_string($faxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxNumber, true), gettype($faxNumber)), __LINE__);
        }
        $this->FaxNumber = $faxNumber;
        return $this;
    }
    /**
     * Get EMailAddress value
     * @return string|null
     */
    public function getEMailAddress()
    {
        return $this->EMailAddress;
    }
    /**
     * Set EMailAddress value
     * @param string $eMailAddress
     * @return \StructType\ShipperType
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMailAddress, true), gettype($eMailAddress)), __LINE__);
        }
        $this->EMailAddress = $eMailAddress;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\ShipAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\ShipAddressType $address
     * @return \StructType\ShipperType
     */
    public function setAddress(\StructType\ShipAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
