<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductWeightType StructType
 * @subpackage Structs
 */
class ProductWeightType extends AbstractStructBase
{
    /**
     * The UnitOfMeasurement
     * @var \StructType\UnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * The Weight
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for ProductWeightType
     * @uses ProductWeightType::setUnitOfMeasurement()
     * @uses ProductWeightType::setWeight()
     * @param \StructType\UnitOfMeasurementType $unitOfMeasurement
     * @param string $weight
     */
    public function __construct(\StructType\UnitOfMeasurementType $unitOfMeasurement = null, $weight = null)
    {
        $this
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setWeight($weight);
    }
    /**
     * Get UnitOfMeasurement value
     * @return \StructType\UnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \StructType\UnitOfMeasurementType $unitOfMeasurement
     * @return \StructType\ProductWeightType
     */
    public function setUnitOfMeasurement(\StructType\UnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \StructType\ProductWeightType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
}
