<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IntermediateConsigneeType StructType
 * @subpackage Structs
 */
class IntermediateConsigneeType extends AbstractStructBase
{
    /**
     * The CompanyName
     * @var string
     */
    public $CompanyName;
    /**
     * The Address
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * Constructor method for IntermediateConsigneeType
     * @uses IntermediateConsigneeType::setCompanyName()
     * @uses IntermediateConsigneeType::setAddress()
     * @param string $companyName
     * @param \StructType\AddressType $address
     */
    public function __construct($companyName = null, \StructType\AddressType $address = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddress($address);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\IntermediateConsigneeType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\IntermediateConsigneeType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
