<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FRSPaymentInfoType StructType
 * @subpackage Structs
 */
class FRSPaymentInfoType extends AbstractStructBase
{
    /**
     * The Type
     * @var \StructType\PaymentType
     */
    public $Type;
    /**
     * The AccountNumber
     * @var string
     */
    public $AccountNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountAddressType
     */
    public $Address;
    /**
     * Constructor method for FRSPaymentInfoType
     * @uses FRSPaymentInfoType::setType()
     * @uses FRSPaymentInfoType::setAccountNumber()
     * @uses FRSPaymentInfoType::setAddress()
     * @param \StructType\PaymentType $type
     * @param string $accountNumber
     * @param \StructType\AccountAddressType $address
     */
    public function __construct(\StructType\PaymentType $type = null, $accountNumber = null, \StructType\AccountAddressType $address = null)
    {
        $this
            ->setType($type)
            ->setAccountNumber($accountNumber)
            ->setAddress($address);
    }
    /**
     * Get Type value
     * @return \StructType\PaymentType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\PaymentType $type
     * @return \StructType\FRSPaymentInfoType
     */
    public function setType(\StructType\PaymentType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\FRSPaymentInfoType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AccountAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AccountAddressType $address
     * @return \StructType\FRSPaymentInfoType
     */
    public function setAddress(\StructType\AccountAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
}
