<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdjustedHeightType StructType
 * @subpackage Structs
 */
class AdjustedHeightType extends AbstractStructBase
{
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * The UnitOfMeasurement
     * @var \StructType\ShipUnitOfMeasurementType
     */
    public $UnitOfMeasurement;
    /**
     * Constructor method for AdjustedHeightType
     * @uses AdjustedHeightType::setValue()
     * @uses AdjustedHeightType::setUnitOfMeasurement()
     * @param string $value
     * @param \StructType\ShipUnitOfMeasurementType $unitOfMeasurement
     */
    public function __construct($value = null, \StructType\ShipUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this
            ->setValue($value)
            ->setUnitOfMeasurement($unitOfMeasurement);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\AdjustedHeightType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return \StructType\ShipUnitOfMeasurementType|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @param \StructType\ShipUnitOfMeasurementType $unitOfMeasurement
     * @return \StructType\AdjustedHeightType
     */
    public function setUnitOfMeasurement(\StructType\ShipUnitOfMeasurementType $unitOfMeasurement = null)
    {
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
}
