<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Device StructType
 * @subpackage Structs
 */
class Device extends AbstractStructBase
{
    /**
     * The hw
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $hw;
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $text;
    /**
     * Constructor method for Device
     * @uses Device::setHw()
     * @uses Device::setText()
     * @param string $hw
     * @param string $text
     */
    public function __construct($hw = null, $text = null)
    {
        $this
            ->setHw($hw)
            ->setText($text);
    }
    /**
     * Get hw value
     * @return string
     */
    public function getHw()
    {
        return $this->hw;
    }
    /**
     * Set hw value
     * @param string $hw
     * @return \StructType\Device
     */
    public function setHw($hw = null)
    {
        // validation for constraint: string
        if (!is_null($hw) && !is_string($hw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hw)), __LINE__);
        }
        $this->hw = $hw;
        return $this;
    }
    /**
     * Get text value
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\Device
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Device
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
