<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Location ServiceType
 * @subpackage Services
 */
class Location extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LocationUrl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $v501
     * @param string $v700
     * @param string $v800
     * @param string $vx1000
     * @param string $loc
     * @param string $tls
     * @return string|bool
     */
    public function LocationUrl($v501, $v700, $v800, $vx1000, $loc, $tls)
    {
        try {
            $this->setResult(self::getSoapClient()->LocationUrl($v501, $v700, $v800, $vx1000, $loc, $tls));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
