<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for testSierologicoType StructType
 * @subpackage Structs
 */
class TestSierologicoType extends AbstractStructBase
{
    /**
     * The dataTest
     * Meta information extracted from the WSDL
     * - documentation: Data del Test Sierologico nel formato "yyyy/MM/dd HH:MM"
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 10
     * - minOccurs: 1
     * @var string
     */
    public $dataTest;
    /**
     * The protocolloTransazione
     * Meta information extracted from the WSDL
     * - documentation: Identificativo univoco della transazione, ottenuto nell'invio del test sierologico
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $protocolloTransazione;
    /**
     * The timestampInvioTestSierologico
     * Meta information extracted from the WSDL
     * - documentation: Data della transazione nel formato "yyyy/MM/dd HH.mm.ss.SSS", ottenuto nell'invio del test sierologico
     * - base: xs:string
     * - maxLength: 23
     * - minLength: 23
     * - minOccurs: 1
     * @var string
     */
    public $timestampInvioTestSierologico;
    /**
     * The cfAssistito
     * Meta information extracted from the WSDL
     * - documentation: CF dell'assistito
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $cfAssistito;
    /**
     * The nomeAssistito
     * Meta information extracted from the WSDL
     * - documentation: Nome dell'assistito
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $nomeAssistito;
    /**
     * The cognomeAssistito
     * Meta information extracted from the WSDL
     * - documentation: Cognome dell'assistito
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $cognomeAssistito;
    /**
     * The opzioniTest
     * Meta information extracted from the WSDL
     * - documentation: Elenco campi opzionali legati a testSierologicoType
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\OpzioniType[]
     */
    public $opzioniTest;
    /**
     * Constructor method for testSierologicoType
     * @uses TestSierologicoType::setDataTest()
     * @uses TestSierologicoType::setProtocolloTransazione()
     * @uses TestSierologicoType::setTimestampInvioTestSierologico()
     * @uses TestSierologicoType::setCfAssistito()
     * @uses TestSierologicoType::setNomeAssistito()
     * @uses TestSierologicoType::setCognomeAssistito()
     * @uses TestSierologicoType::setOpzioniTest()
     * @param string $dataTest
     * @param string $protocolloTransazione
     * @param string $timestampInvioTestSierologico
     * @param string $cfAssistito
     * @param string $nomeAssistito
     * @param string $cognomeAssistito
     * @param \StructType\OpzioniType[] $opzioniTest
     */
    public function __construct($dataTest = null, $protocolloTransazione = null, $timestampInvioTestSierologico = null, $cfAssistito = null, $nomeAssistito = null, $cognomeAssistito = null, array $opzioniTest = array())
    {
        $this
            ->setDataTest($dataTest)
            ->setProtocolloTransazione($protocolloTransazione)
            ->setTimestampInvioTestSierologico($timestampInvioTestSierologico)
            ->setCfAssistito($cfAssistito)
            ->setNomeAssistito($nomeAssistito)
            ->setCognomeAssistito($cognomeAssistito)
            ->setOpzioniTest($opzioniTest);
    }
    /**
     * Get dataTest value
     * @return string
     */
    public function getDataTest()
    {
        return $this->dataTest;
    }
    /**
     * Set dataTest value
     * @param string $dataTest
     * @return \StructType\TestSierologicoType
     */
    public function setDataTest($dataTest = null)
    {
        // validation for constraint: string
        if (!is_null($dataTest) && !is_string($dataTest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTest, true), gettype($dataTest)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($dataTest) && mb_strlen($dataTest) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($dataTest)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($dataTest) && mb_strlen($dataTest) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($dataTest)), __LINE__);
        }
        $this->dataTest = $dataTest;
        return $this;
    }
    /**
     * Get protocolloTransazione value
     * @return string
     */
    public function getProtocolloTransazione()
    {
        return $this->protocolloTransazione;
    }
    /**
     * Set protocolloTransazione value
     * @param string $protocolloTransazione
     * @return \StructType\TestSierologicoType
     */
    public function setProtocolloTransazione($protocolloTransazione = null)
    {
        // validation for constraint: string
        if (!is_null($protocolloTransazione) && !is_string($protocolloTransazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocolloTransazione, true), gettype($protocolloTransazione)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($protocolloTransazione) && mb_strlen($protocolloTransazione) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($protocolloTransazione)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($protocolloTransazione) && mb_strlen($protocolloTransazione) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($protocolloTransazione)), __LINE__);
        }
        $this->protocolloTransazione = $protocolloTransazione;
        return $this;
    }
    /**
     * Get timestampInvioTestSierologico value
     * @return string
     */
    public function getTimestampInvioTestSierologico()
    {
        return $this->timestampInvioTestSierologico;
    }
    /**
     * Set timestampInvioTestSierologico value
     * @param string $timestampInvioTestSierologico
     * @return \StructType\TestSierologicoType
     */
    public function setTimestampInvioTestSierologico($timestampInvioTestSierologico = null)
    {
        // validation for constraint: string
        if (!is_null($timestampInvioTestSierologico) && !is_string($timestampInvioTestSierologico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampInvioTestSierologico, true), gettype($timestampInvioTestSierologico)), __LINE__);
        }
        // validation for constraint: maxLength(23)
        if (!is_null($timestampInvioTestSierologico) && mb_strlen($timestampInvioTestSierologico) > 23) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 23', mb_strlen($timestampInvioTestSierologico)), __LINE__);
        }
        // validation for constraint: minLength(23)
        if (!is_null($timestampInvioTestSierologico) && mb_strlen($timestampInvioTestSierologico) < 23) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 23', mb_strlen($timestampInvioTestSierologico)), __LINE__);
        }
        $this->timestampInvioTestSierologico = $timestampInvioTestSierologico;
        return $this;
    }
    /**
     * Get cfAssistito value
     * @return string|null
     */
    public function getCfAssistito()
    {
        return $this->cfAssistito;
    }
    /**
     * Set cfAssistito value
     * @param string $cfAssistito
     * @return \StructType\TestSierologicoType
     */
    public function setCfAssistito($cfAssistito = null)
    {
        // validation for constraint: string
        if (!is_null($cfAssistito) && !is_string($cfAssistito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfAssistito, true), gettype($cfAssistito)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($cfAssistito) && mb_strlen($cfAssistito) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($cfAssistito)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cfAssistito) && mb_strlen($cfAssistito) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cfAssistito)), __LINE__);
        }
        $this->cfAssistito = $cfAssistito;
        return $this;
    }
    /**
     * Get nomeAssistito value
     * @return string|null
     */
    public function getNomeAssistito()
    {
        return $this->nomeAssistito;
    }
    /**
     * Set nomeAssistito value
     * @param string $nomeAssistito
     * @return \StructType\TestSierologicoType
     */
    public function setNomeAssistito($nomeAssistito = null)
    {
        // validation for constraint: string
        if (!is_null($nomeAssistito) && !is_string($nomeAssistito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeAssistito, true), gettype($nomeAssistito)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($nomeAssistito) && mb_strlen($nomeAssistito) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($nomeAssistito)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nomeAssistito) && mb_strlen($nomeAssistito) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nomeAssistito)), __LINE__);
        }
        $this->nomeAssistito = $nomeAssistito;
        return $this;
    }
    /**
     * Get cognomeAssistito value
     * @return string|null
     */
    public function getCognomeAssistito()
    {
        return $this->cognomeAssistito;
    }
    /**
     * Set cognomeAssistito value
     * @param string $cognomeAssistito
     * @return \StructType\TestSierologicoType
     */
    public function setCognomeAssistito($cognomeAssistito = null)
    {
        // validation for constraint: string
        if (!is_null($cognomeAssistito) && !is_string($cognomeAssistito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cognomeAssistito, true), gettype($cognomeAssistito)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($cognomeAssistito) && mb_strlen($cognomeAssistito) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($cognomeAssistito)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cognomeAssistito) && mb_strlen($cognomeAssistito) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cognomeAssistito)), __LINE__);
        }
        $this->cognomeAssistito = $cognomeAssistito;
        return $this;
    }
    /**
     * Get opzioniTest value
     * @return \StructType\OpzioniType[]|null
     */
    public function getOpzioniTest()
    {
        return $this->opzioniTest;
    }
    /**
     * This method is responsible for validating the values passed to the setOpzioniTest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpzioniTest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpzioniTestForArrayConstraintsFromSetOpzioniTest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $testSierologicoTypeOpzioniTestItem) {
            // validation for constraint: itemType
            if (!$testSierologicoTypeOpzioniTestItem instanceof \StructType\OpzioniType) {
                $invalidValues[] = is_object($testSierologicoTypeOpzioniTestItem) ? get_class($testSierologicoTypeOpzioniTestItem) : sprintf('%s(%s)', gettype($testSierologicoTypeOpzioniTestItem), var_export($testSierologicoTypeOpzioniTestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The opzioniTest property can only contain items of type \StructType\OpzioniType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set opzioniTest value
     * @throws \InvalidArgumentException
     * @param \StructType\OpzioniType[] $opzioniTest
     * @return \StructType\TestSierologicoType
     */
    public function setOpzioniTest(array $opzioniTest = array())
    {
        // validation for constraint: array
        if ('' !== ($opzioniTestArrayErrorMessage = self::validateOpzioniTestForArrayConstraintsFromSetOpzioniTest($opzioniTest))) {
            throw new \InvalidArgumentException($opzioniTestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($opzioniTest) && count($opzioniTest) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($opzioniTest)), __LINE__);
        }
        $this->opzioniTest = $opzioniTest;
        return $this;
    }
    /**
     * Add item to opzioniTest value
     * @throws \InvalidArgumentException
     * @param \StructType\OpzioniType $item
     * @return \StructType\TestSierologicoType
     */
    public function addToOpzioniTest(\StructType\OpzioniType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpzioniType) {
            throw new \InvalidArgumentException(sprintf('The opzioniTest property can only contain items of type \StructType\OpzioniType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->opzioniTest) && count($this->opzioniTest) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->opzioniTest)), __LINE__);
        }
        $this->opzioniTest[] = $item;
        return $this;
    }
}
