<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for opzioniType StructType
 * @subpackage Structs
 */
class OpzioniType extends AbstractStructBase
{
    /**
     * The chiave
     * Meta information extracted from the WSDL
     * - documentation: Chiave del campo
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $chiave;
    /**
     * The valore
     * Meta information extracted from the WSDL
     * - documentation: Valore del campo
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $valore;
    /**
     * The tipo
     * Meta information extracted from the WSDL
     * - documentation: Tipologia del campo
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $tipo;
    /**
     * Constructor method for opzioniType
     * @uses OpzioniType::setChiave()
     * @uses OpzioniType::setValore()
     * @uses OpzioniType::setTipo()
     * @param string $chiave
     * @param string $valore
     * @param string $tipo
     */
    public function __construct($chiave = null, $valore = null, $tipo = null)
    {
        $this
            ->setChiave($chiave)
            ->setValore($valore)
            ->setTipo($tipo);
    }
    /**
     * Get chiave value
     * @return string
     */
    public function getChiave()
    {
        return $this->chiave;
    }
    /**
     * Set chiave value
     * @param string $chiave
     * @return \StructType\OpzioniType
     */
    public function setChiave($chiave = null)
    {
        // validation for constraint: string
        if (!is_null($chiave) && !is_string($chiave)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chiave, true), gettype($chiave)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($chiave) && mb_strlen($chiave) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($chiave)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($chiave) && mb_strlen($chiave) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($chiave)), __LINE__);
        }
        $this->chiave = $chiave;
        return $this;
    }
    /**
     * Get valore value
     * @return string
     */
    public function getValore()
    {
        return $this->valore;
    }
    /**
     * Set valore value
     * @param string $valore
     * @return \StructType\OpzioniType
     */
    public function setValore($valore = null)
    {
        // validation for constraint: string
        if (!is_null($valore) && !is_string($valore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valore, true), gettype($valore)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($valore) && mb_strlen($valore) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($valore)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($valore) && mb_strlen($valore) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($valore)), __LINE__);
        }
        $this->valore = $valore;
        return $this;
    }
    /**
     * Get tipo value
     * @return string|null
     */
    public function getTipo()
    {
        return $this->tipo;
    }
    /**
     * Set tipo value
     * @param string $tipo
     * @return \StructType\OpzioniType
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: string
        if (!is_null($tipo) && !is_string($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($tipo) && mb_strlen($tipo) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($tipo)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($tipo) && mb_strlen($tipo) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($tipo)), __LINE__);
        }
        $this->tipo = $tipo;
        return $this;
    }
}
