<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElencoTestSierologiciRichiesta StructType
 * @subpackage Structs
 */
class ElencoTestSierologiciRichiesta extends AbstractStructBase
{
    /**
     * The dataDa
     * Meta information extracted from the WSDL
     * - documentation: Data inferiore nel formato "yyyy/MM/dd
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 10
     * - minOccurs: 1
     * @var string
     */
    public $dataDa;
    /**
     * The dataA
     * Meta information extracted from the WSDL
     * - documentation: Data superiore nel formato "yyyy/MM/dd
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 10
     * - minOccurs: 1
     * @var string
     */
    public $dataA;
    /**
     * The idUtenteRichiedente
     * Meta information extracted from the WSDL
     * - documentation: CF dell'utente
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $idUtenteRichiedente;
    /**
     * The cfMedicoTitolare
     * Meta information extracted from the WSDL
     * - documentation: CF del medico titolare. Questo campo puo' coincidere con il valore del campo idUtenteRichiedente oppure differire nel caso di presenza del medico sostituto
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $cfMedicoTitolare;
    /**
     * The pinCodeUtente
     * Meta information extracted from the WSDL
     * - documentation: PinCode utente, non impostare per i SAR
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $pinCodeUtente;
    /**
     * The OpzioniRequest
     * Meta information extracted from the WSDL
     * - documentation: Elenco campi opzionali
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\OpzioniType[]
     */
    public $OpzioniRequest;
    /**
     * Constructor method for ElencoTestSierologiciRichiesta
     * @uses ElencoTestSierologiciRichiesta::setDataDa()
     * @uses ElencoTestSierologiciRichiesta::setDataA()
     * @uses ElencoTestSierologiciRichiesta::setIdUtenteRichiedente()
     * @uses ElencoTestSierologiciRichiesta::setCfMedicoTitolare()
     * @uses ElencoTestSierologiciRichiesta::setPinCodeUtente()
     * @uses ElencoTestSierologiciRichiesta::setOpzioniRequest()
     * @param string $dataDa
     * @param string $dataA
     * @param string $idUtenteRichiedente
     * @param string $cfMedicoTitolare
     * @param string $pinCodeUtente
     * @param \StructType\OpzioniType[] $opzioniRequest
     */
    public function __construct($dataDa = null, $dataA = null, $idUtenteRichiedente = null, $cfMedicoTitolare = null, $pinCodeUtente = null, array $opzioniRequest = array())
    {
        $this
            ->setDataDa($dataDa)
            ->setDataA($dataA)
            ->setIdUtenteRichiedente($idUtenteRichiedente)
            ->setCfMedicoTitolare($cfMedicoTitolare)
            ->setPinCodeUtente($pinCodeUtente)
            ->setOpzioniRequest($opzioniRequest);
    }
    /**
     * Get dataDa value
     * @return string
     */
    public function getDataDa()
    {
        return $this->dataDa;
    }
    /**
     * Set dataDa value
     * @param string $dataDa
     * @return \StructType\ElencoTestSierologiciRichiesta
     */
    public function setDataDa($dataDa = null)
    {
        // validation for constraint: string
        if (!is_null($dataDa) && !is_string($dataDa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDa, true), gettype($dataDa)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($dataDa) && mb_strlen($dataDa) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($dataDa)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($dataDa) && mb_strlen($dataDa) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($dataDa)), __LINE__);
        }
        $this->dataDa = $dataDa;
        return $this;
    }
    /**
     * Get dataA value
     * @return string
     */
    public function getDataA()
    {
        return $this->dataA;
    }
    /**
     * Set dataA value
     * @param string $dataA
     * @return \StructType\ElencoTestSierologiciRichiesta
     */
    public function setDataA($dataA = null)
    {
        // validation for constraint: string
        if (!is_null($dataA) && !is_string($dataA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataA, true), gettype($dataA)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($dataA) && mb_strlen($dataA) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($dataA)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($dataA) && mb_strlen($dataA) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($dataA)), __LINE__);
        }
        $this->dataA = $dataA;
        return $this;
    }
    /**
     * Get idUtenteRichiedente value
     * @return string|null
     */
    public function getIdUtenteRichiedente()
    {
        return $this->idUtenteRichiedente;
    }
    /**
     * Set idUtenteRichiedente value
     * @param string $idUtenteRichiedente
     * @return \StructType\ElencoTestSierologiciRichiesta
     */
    public function setIdUtenteRichiedente($idUtenteRichiedente = null)
    {
        // validation for constraint: string
        if (!is_null($idUtenteRichiedente) && !is_string($idUtenteRichiedente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idUtenteRichiedente, true), gettype($idUtenteRichiedente)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($idUtenteRichiedente) && mb_strlen($idUtenteRichiedente) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($idUtenteRichiedente)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($idUtenteRichiedente) && mb_strlen($idUtenteRichiedente) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($idUtenteRichiedente)), __LINE__);
        }
        $this->idUtenteRichiedente = $idUtenteRichiedente;
        return $this;
    }
    /**
     * Get cfMedicoTitolare value
     * @return string|null
     */
    public function getCfMedicoTitolare()
    {
        return $this->cfMedicoTitolare;
    }
    /**
     * Set cfMedicoTitolare value
     * @param string $cfMedicoTitolare
     * @return \StructType\ElencoTestSierologiciRichiesta
     */
    public function setCfMedicoTitolare($cfMedicoTitolare = null)
    {
        // validation for constraint: string
        if (!is_null($cfMedicoTitolare) && !is_string($cfMedicoTitolare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cfMedicoTitolare, true), gettype($cfMedicoTitolare)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($cfMedicoTitolare) && mb_strlen($cfMedicoTitolare) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($cfMedicoTitolare)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($cfMedicoTitolare) && mb_strlen($cfMedicoTitolare) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($cfMedicoTitolare)), __LINE__);
        }
        $this->cfMedicoTitolare = $cfMedicoTitolare;
        return $this;
    }
    /**
     * Get pinCodeUtente value
     * @return string|null
     */
    public function getPinCodeUtente()
    {
        return $this->pinCodeUtente;
    }
    /**
     * Set pinCodeUtente value
     * @param string $pinCodeUtente
     * @return \StructType\ElencoTestSierologiciRichiesta
     */
    public function setPinCodeUtente($pinCodeUtente = null)
    {
        // validation for constraint: string
        if (!is_null($pinCodeUtente) && !is_string($pinCodeUtente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pinCodeUtente, true), gettype($pinCodeUtente)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($pinCodeUtente) && mb_strlen($pinCodeUtente) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($pinCodeUtente)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($pinCodeUtente) && mb_strlen($pinCodeUtente) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($pinCodeUtente)), __LINE__);
        }
        $this->pinCodeUtente = $pinCodeUtente;
        return $this;
    }
    /**
     * Get OpzioniRequest value
     * @return \StructType\OpzioniType[]|null
     */
    public function getOpzioniRequest()
    {
        return $this->OpzioniRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setOpzioniRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpzioniRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpzioniRequestForArrayConstraintsFromSetOpzioniRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $elencoTestSierologiciRichiestaOpzioniRequestItem) {
            // validation for constraint: itemType
            if (!$elencoTestSierologiciRichiestaOpzioniRequestItem instanceof \StructType\OpzioniType) {
                $invalidValues[] = is_object($elencoTestSierologiciRichiestaOpzioniRequestItem) ? get_class($elencoTestSierologiciRichiestaOpzioniRequestItem) : sprintf('%s(%s)', gettype($elencoTestSierologiciRichiestaOpzioniRequestItem), var_export($elencoTestSierologiciRichiestaOpzioniRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OpzioniRequest property can only contain items of type \StructType\OpzioniType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OpzioniRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\OpzioniType[] $opzioniRequest
     * @return \StructType\ElencoTestSierologiciRichiesta
     */
    public function setOpzioniRequest(array $opzioniRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($opzioniRequestArrayErrorMessage = self::validateOpzioniRequestForArrayConstraintsFromSetOpzioniRequest($opzioniRequest))) {
            throw new \InvalidArgumentException($opzioniRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($opzioniRequest) && count($opzioniRequest) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($opzioniRequest)), __LINE__);
        }
        $this->OpzioniRequest = $opzioniRequest;
        return $this;
    }
    /**
     * Add item to OpzioniRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\OpzioniType $item
     * @return \StructType\ElencoTestSierologiciRichiesta
     */
    public function addToOpzioniRequest(\StructType\OpzioniType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpzioniType) {
            throw new \InvalidArgumentException(sprintf('The OpzioniRequest property can only contain items of type \StructType\OpzioniType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->OpzioniRequest) && count($this->OpzioniRequest) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->OpzioniRequest)), __LINE__);
        }
        $this->OpzioniRequest[] = $item;
        return $this;
    }
}
