<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElencoTestSierologiciRicevuta StructType
 * @subpackage Structs
 */
class ElencoTestSierologiciRicevuta extends AbstractStructBase
{
    /**
     * The protocolloTransazione
     * Meta information extracted from the WSDL
     * - documentation: Identificativo univoco della transazione
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * @var string
     */
    public $protocolloTransazione;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - documentation: Data della transazione nel formato "yyyy/MM/dd HH.mm.ss.SSS"
     * - base: xs:string
     * - maxLength: 23
     * - minLength: 23
     * @var string
     */
    public $timestamp;
    /**
     * The esito
     * Meta information extracted from the WSDL
     * - documentation: Esito della transazione
     * - base: xs:string
     * - pattern: [0-9]{2}
     * @var string
     */
    public $esito;
    /**
     * The descrizioneEsito
     * Meta information extracted from the WSDL
     * - documentation: Esito della transazione
     * - base: xs:string
     * - maxLength: 256
     * - minLength: 0
     * @var string
     */
    public $descrizioneEsito;
    /**
     * The listaTestSierologici
     * Meta information extracted from the WSDL
     * - documentation: Lista dei Test Sierologici
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TestSierologicoType[]
     */
    public $listaTestSierologici;
    /**
     * Constructor method for ElencoTestSierologiciRicevuta
     * @uses ElencoTestSierologiciRicevuta::setProtocolloTransazione()
     * @uses ElencoTestSierologiciRicevuta::setTimestamp()
     * @uses ElencoTestSierologiciRicevuta::setEsito()
     * @uses ElencoTestSierologiciRicevuta::setDescrizioneEsito()
     * @uses ElencoTestSierologiciRicevuta::setListaTestSierologici()
     * @param string $protocolloTransazione
     * @param string $timestamp
     * @param string $esito
     * @param string $descrizioneEsito
     * @param \StructType\TestSierologicoType[] $listaTestSierologici
     */
    public function __construct($protocolloTransazione = null, $timestamp = null, $esito = null, $descrizioneEsito = null, array $listaTestSierologici = array())
    {
        $this
            ->setProtocolloTransazione($protocolloTransazione)
            ->setTimestamp($timestamp)
            ->setEsito($esito)
            ->setDescrizioneEsito($descrizioneEsito)
            ->setListaTestSierologici($listaTestSierologici);
    }
    /**
     * Get protocolloTransazione value
     * @return string|null
     */
    public function getProtocolloTransazione()
    {
        return $this->protocolloTransazione;
    }
    /**
     * Set protocolloTransazione value
     * @param string $protocolloTransazione
     * @return \StructType\ElencoTestSierologiciRicevuta
     */
    public function setProtocolloTransazione($protocolloTransazione = null)
    {
        // validation for constraint: string
        if (!is_null($protocolloTransazione) && !is_string($protocolloTransazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocolloTransazione, true), gettype($protocolloTransazione)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($protocolloTransazione) && mb_strlen($protocolloTransazione) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($protocolloTransazione)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($protocolloTransazione) && mb_strlen($protocolloTransazione) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($protocolloTransazione)), __LINE__);
        }
        $this->protocolloTransazione = $protocolloTransazione;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\ElencoTestSierologiciRicevuta
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        // validation for constraint: maxLength(23)
        if (!is_null($timestamp) && mb_strlen($timestamp) > 23) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 23', mb_strlen($timestamp)), __LINE__);
        }
        // validation for constraint: minLength(23)
        if (!is_null($timestamp) && mb_strlen($timestamp) < 23) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 23', mb_strlen($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get esito value
     * @return string|null
     */
    public function getEsito()
    {
        return $this->esito;
    }
    /**
     * Set esito value
     * @param string $esito
     * @return \StructType\ElencoTestSierologiciRicevuta
     */
    public function setEsito($esito = null)
    {
        // validation for constraint: string
        if (!is_null($esito) && !is_string($esito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esito, true), gettype($esito)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2})
        if (!is_null($esito) && !preg_match('/[0-9]{2}/', $esito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}', var_export($esito, true)), __LINE__);
        }
        $this->esito = $esito;
        return $this;
    }
    /**
     * Get descrizioneEsito value
     * @return string|null
     */
    public function getDescrizioneEsito()
    {
        return $this->descrizioneEsito;
    }
    /**
     * Set descrizioneEsito value
     * @param string $descrizioneEsito
     * @return \StructType\ElencoTestSierologiciRicevuta
     */
    public function setDescrizioneEsito($descrizioneEsito = null)
    {
        // validation for constraint: string
        if (!is_null($descrizioneEsito) && !is_string($descrizioneEsito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizioneEsito, true), gettype($descrizioneEsito)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($descrizioneEsito) && mb_strlen($descrizioneEsito) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($descrizioneEsito)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($descrizioneEsito) && mb_strlen($descrizioneEsito) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($descrizioneEsito)), __LINE__);
        }
        $this->descrizioneEsito = $descrizioneEsito;
        return $this;
    }
    /**
     * Get listaTestSierologici value
     * @return \StructType\TestSierologicoType[]|null
     */
    public function getListaTestSierologici()
    {
        return $this->listaTestSierologici;
    }
    /**
     * This method is responsible for validating the values passed to the setListaTestSierologici method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListaTestSierologici method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListaTestSierologiciForArrayConstraintsFromSetListaTestSierologici(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $elencoTestSierologiciRicevutaListaTestSierologiciItem) {
            // validation for constraint: itemType
            if (!$elencoTestSierologiciRicevutaListaTestSierologiciItem instanceof \StructType\TestSierologicoType) {
                $invalidValues[] = is_object($elencoTestSierologiciRicevutaListaTestSierologiciItem) ? get_class($elencoTestSierologiciRicevutaListaTestSierologiciItem) : sprintf('%s(%s)', gettype($elencoTestSierologiciRicevutaListaTestSierologiciItem), var_export($elencoTestSierologiciRicevutaListaTestSierologiciItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listaTestSierologici property can only contain items of type \StructType\TestSierologicoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listaTestSierologici value
     * @throws \InvalidArgumentException
     * @param \StructType\TestSierologicoType[] $listaTestSierologici
     * @return \StructType\ElencoTestSierologiciRicevuta
     */
    public function setListaTestSierologici(array $listaTestSierologici = array())
    {
        // validation for constraint: array
        if ('' !== ($listaTestSierologiciArrayErrorMessage = self::validateListaTestSierologiciForArrayConstraintsFromSetListaTestSierologici($listaTestSierologici))) {
            throw new \InvalidArgumentException($listaTestSierologiciArrayErrorMessage, __LINE__);
        }
        $this->listaTestSierologici = $listaTestSierologici;
        return $this;
    }
    /**
     * Add item to listaTestSierologici value
     * @throws \InvalidArgumentException
     * @param \StructType\TestSierologicoType $item
     * @return \StructType\ElencoTestSierologiciRicevuta
     */
    public function addToListaTestSierologici(\StructType\TestSierologicoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TestSierologicoType) {
            throw new \InvalidArgumentException(sprintf('The listaTestSierologici property can only contain items of type \StructType\TestSierologicoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listaTestSierologici[] = $item;
        return $this;
    }
}
