<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Elenco ServiceType
 * @subpackage Services
 */
class Elenco extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named elencoTestSierologici
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ElencoTestSierologiciRichiesta $elencoTestSierologiciRichiesta
     * @return \StructType\ElencoTestSierologiciRicevuta|bool
     */
    public function elencoTestSierologici(\StructType\ElencoTestSierologiciRichiesta $elencoTestSierologiciRichiesta)
    {
        try {
            $this->setResult($this->getSoapClient()->elencoTestSierologici($elencoTestSierologiciRichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ElencoTestSierologiciRicevuta
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
