<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.perfectview.nl/perfectview.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.perfectview.nl/perfectview.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Note ServiceType
 */
$note = new \ServiceType\Note($options);
/**
 * Sample call for NoteGet operation/method
 */
if ($note->NoteGet(new \StructType\NoteGet()) !== false) {
    print_r($note->getResult());
} else {
    print_r($note->getLastError());
}
/**
 * Sample call for NoteUpdate operation/method
 */
if ($note->NoteUpdate(new \StructType\NoteUpdate()) !== false) {
    print_r($note->getResult());
} else {
    print_r($note->getLastError());
}
/**
 * Sample call for NoteExists operation/method
 */
if ($note->NoteExists(new \StructType\NoteExists()) !== false) {
    print_r($note->getResult());
} else {
    print_r($note->getLastError());
}
/**
 * Samples for Attachment ServiceType
 */
$attachment = new \ServiceType\Attachment($options);
/**
 * Sample call for AttachmentGetLabels operation/method
 */
if ($attachment->AttachmentGetLabels(new \StructType\AttachmentGetLabels()) !== false) {
    print_r($attachment->getResult());
} else {
    print_r($attachment->getLastError());
}
/**
 * Sample call for AttachmentUpdate operation/method
 */
if ($attachment->AttachmentUpdate(new \StructType\AttachmentUpdate()) !== false) {
    print_r($attachment->getResult());
} else {
    print_r($attachment->getLastError());
}
/**
 * Sample call for AttachmentAddLabel operation/method
 */
if ($attachment->AttachmentAddLabel(new \StructType\AttachmentAddLabel()) !== false) {
    print_r($attachment->getResult());
} else {
    print_r($attachment->getLastError());
}
/**
 * Sample call for AttachmentExists operation/method
 */
if ($attachment->AttachmentExists(new \StructType\AttachmentExists()) !== false) {
    print_r($attachment->getResult());
} else {
    print_r($attachment->getLastError());
}
/**
 * Sample call for AttachmentGet operation/method
 */
if ($attachment->AttachmentGet(new \StructType\AttachmentGet()) !== false) {
    print_r($attachment->getResult());
} else {
    print_r($attachment->getLastError());
}
/**
 * Sample call for AttachmentGetGoogleDocsUrl operation/method
 */
if ($attachment->AttachmentGetGoogleDocsUrl(new \StructType\AttachmentGetGoogleDocsUrl()) !== false) {
    print_r($attachment->getResult());
} else {
    print_r($attachment->getLastError());
}
/**
 * Samples for Activity ServiceType
 */
$activity = new \ServiceType\Activity($options);
/**
 * Sample call for ActivityGetLabels operation/method
 */
if ($activity->ActivityGetLabels(new \StructType\ActivityGetLabels()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityCreate operation/method
 */
if ($activity->ActivityCreate(new \StructType\ActivityCreate()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityUpdate operation/method
 */
if ($activity->ActivityUpdate(new \StructType\ActivityUpdate()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddReference operation/method
 */
if ($activity->ActivityAddReference(new \StructType\ActivityAddReference()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityFlow operation/method
 */
if ($activity->ActivityFlow(new \StructType\ActivityFlow()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityClose operation/method
 */
if ($activity->ActivityClose(new \StructType\ActivityClose()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddAttachment operation/method
 */
if ($activity->ActivityAddAttachment(new \StructType\ActivityAddAttachment()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityDeleteAttachment operation/method
 */
if ($activity->ActivityDeleteAttachment(new \StructType\ActivityDeleteAttachment()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddNote operation/method
 */
if ($activity->ActivityAddNote(new \StructType\ActivityAddNote()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddNote_V2 operation/method
 */
if ($activity->ActivityAddNote_V2(new \StructType\ActivityAddNote_V2()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddNote_V3 operation/method
 */
if ($activity->ActivityAddNote_V3(new \StructType\ActivityAddNote_V3()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddInvolved operation/method
 */
if ($activity->ActivityAddInvolved(new \StructType\ActivityAddInvolved()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddProductLine operation/method
 */
if ($activity->ActivityAddProductLine(new \StructType\ActivityAddProductLine()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityDeleteProductLine operation/method
 */
if ($activity->ActivityDeleteProductLine(new \StructType\ActivityDeleteProductLine()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityDeleteProductLines operation/method
 */
if ($activity->ActivityDeleteProductLines(new \StructType\ActivityDeleteProductLines()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddParameters operation/method
 */
if ($activity->ActivityAddParameters(new \StructType\ActivityAddParameters()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddLine operation/method
 */
if ($activity->ActivityAddLine(new \StructType\ActivityAddLine()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddLineV2 operation/method
 */
if ($activity->ActivityAddLineV2(new \StructType\ActivityAddLineV2()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddLabel operation/method
 */
if ($activity->ActivityAddLabel(new \StructType\ActivityAddLabel()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityAddFieldLabel operation/method
 */
if ($activity->ActivityAddFieldLabel(new \StructType\ActivityAddFieldLabel()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityViewGetData operation/method
 */
if ($activity->ActivityViewGetData(new \StructType\ActivityViewGetData()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityInvolvedEntityTypesGet operation/method
 */
if ($activity->ActivityInvolvedEntityTypesGet(new \StructType\ActivityInvolvedEntityTypesGet()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetFields operation/method
 */
if ($activity->ActivityGetFields(new \StructType\ActivityGetFields()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityExists operation/method
 */
if ($activity->ActivityExists(new \StructType\ActivityExists()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGet operation/method
 */
if ($activity->ActivityGet(new \StructType\ActivityGet()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetConnectedActivities operation/method
 */
if ($activity->ActivityGetConnectedActivities(new \StructType\ActivityGetConnectedActivities()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivitySearchByField operation/method
 */
if ($activity->ActivitySearchByField(new \StructType\ActivitySearchByField()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivitySearchByFieldInPeriod operation/method
 */
if ($activity->ActivitySearchByFieldInPeriod(new \StructType\ActivitySearchByFieldInPeriod()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivitySearchByFieldInPeriodExact operation/method
 */
if ($activity->ActivitySearchByFieldInPeriodExact(new \StructType\ActivitySearchByFieldInPeriodExact()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetAttachments operation/method
 */
if ($activity->ActivityGetAttachments(new \StructType\ActivityGetAttachments()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetAttachments_V2 operation/method
 */
if ($activity->ActivityGetAttachments_V2(new \StructType\ActivityGetAttachments_V2()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetNotes operation/method
 */
if ($activity->ActivityGetNotes(new \StructType\ActivityGetNotes()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetNotes_V2 operation/method
 */
if ($activity->ActivityGetNotes_V2(new \StructType\ActivityGetNotes_V2()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetInvolveds operation/method
 */
if ($activity->ActivityGetInvolveds(new \StructType\ActivityGetInvolveds()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetProductLines operation/method
 */
if ($activity->ActivityGetProductLines(new \StructType\ActivityGetProductLines()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Sample call for ActivityGetLines operation/method
 */
if ($activity->ActivityGetLines(new \StructType\ActivityGetLines()) !== false) {
    print_r($activity->getResult());
} else {
    print_r($activity->getLastError());
}
/**
 * Samples for Relationship ServiceType
 */
$relationship = new \ServiceType\Relationship($options);
/**
 * Sample call for RelationshipFieldGetLabels operation/method
 */
if ($relationship->RelationshipFieldGetLabels(new \StructType\RelationshipFieldGetLabels()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipCreate operation/method
 */
if ($relationship->RelationshipCreate(new \StructType\RelationshipCreate()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipUpdate operation/method
 */
if ($relationship->RelationshipUpdate(new \StructType\RelationshipUpdate()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipAddMark operation/method
 */
if ($relationship->RelationshipAddMark(new \StructType\RelationshipAddMark()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipAddMarkV2 operation/method
 */
if ($relationship->RelationshipAddMarkV2(new \StructType\RelationshipAddMarkV2()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipRemoveMark operation/method
 */
if ($relationship->RelationshipRemoveMark(new \StructType\RelationshipRemoveMark()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipAddFieldLabel operation/method
 */
if ($relationship->RelationshipAddFieldLabel(new \StructType\RelationshipAddFieldLabel()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipAddLine operation/method
 */
if ($relationship->RelationshipAddLine(new \StructType\RelationshipAddLine()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipAddLineV2 operation/method
 */
if ($relationship->RelationshipAddLineV2(new \StructType\RelationshipAddLineV2()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipViewGetData operation/method
 */
if ($relationship->RelationshipViewGetData(new \StructType\RelationshipViewGetData()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGetFields operation/method
 */
if ($relationship->RelationshipGetFields(new \StructType\RelationshipGetFields()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipExists operation/method
 */
if ($relationship->RelationshipExists(new \StructType\RelationshipExists()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGetAll operation/method
 */
if ($relationship->RelationshipGetAll(new \StructType\RelationshipGetAll()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGetModified operation/method
 */
if ($relationship->RelationshipGetModified(new \StructType\RelationshipGetModified()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGet operation/method
 */
if ($relationship->RelationshipGet(new \StructType\RelationshipGet()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGetEmployees operation/method
 */
if ($relationship->RelationshipGetEmployees(new \StructType\RelationshipGetEmployees()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGetEmployeesModified operation/method
 */
if ($relationship->RelationshipGetEmployeesModified(new \StructType\RelationshipGetEmployeesModified()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipSearchByName operation/method
 */
if ($relationship->RelationshipSearchByName(new \StructType\RelationshipSearchByName()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipSearchByName_V2 operation/method
 */
if ($relationship->RelationshipSearchByName_V2(new \StructType\RelationshipSearchByName_V2()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipSearchByEmail operation/method
 */
if ($relationship->RelationshipSearchByEmail(new \StructType\RelationshipSearchByEmail()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipSearchByField operation/method
 */
if ($relationship->RelationshipSearchByField(new \StructType\RelationshipSearchByField()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipSearchByMark operation/method
 */
if ($relationship->RelationshipSearchByMark(new \StructType\RelationshipSearchByMark()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipSearchByMarkAndDate operation/method
 */
if ($relationship->RelationshipSearchByMarkAndDate(new \StructType\RelationshipSearchByMarkAndDate()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGetMarks operation/method
 */
if ($relationship->RelationshipGetMarks(new \StructType\RelationshipGetMarks()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGetMarksCompact operation/method
 */
if ($relationship->RelationshipGetMarksCompact(new \StructType\RelationshipGetMarksCompact()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Sample call for RelationshipGetLines operation/method
 */
if ($relationship->RelationshipGetLines(new \StructType\RelationshipGetLines()) !== false) {
    print_r($relationship->getResult());
} else {
    print_r($relationship->getLastError());
}
/**
 * Samples for Subscription ServiceType
 */
$subscription = new \ServiceType\Subscription($options);
/**
 * Sample call for SubscriptionCreate operation/method
 */
if ($subscription->SubscriptionCreate(new \StructType\SubscriptionCreate()) !== false) {
    print_r($subscription->getResult());
} else {
    print_r($subscription->getLastError());
}
/**
 * Sample call for SubscriptionUpdate operation/method
 */
if ($subscription->SubscriptionUpdate(new \StructType\SubscriptionUpdate()) !== false) {
    print_r($subscription->getResult());
} else {
    print_r($subscription->getLastError());
}
/**
 * Sample call for SubscriptionAddProductLine operation/method
 */
if ($subscription->SubscriptionAddProductLine(new \StructType\SubscriptionAddProductLine()) !== false) {
    print_r($subscription->getResult());
} else {
    print_r($subscription->getLastError());
}
/**
 * Samples for Relation ServiceType
 */
$relation = new \ServiceType\Relation($options);
/**
 * Sample call for RelationCreate operation/method
 */
if ($relation->RelationCreate(new \StructType\RelationCreate()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationUpdate operation/method
 */
if ($relation->RelationUpdate(new \StructType\RelationUpdate()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationAddAttachment operation/method
 */
if ($relation->RelationAddAttachment(new \StructType\RelationAddAttachment()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationDeleteAttachment operation/method
 */
if ($relation->RelationDeleteAttachment(new \StructType\RelationDeleteAttachment()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationAddNote operation/method
 */
if ($relation->RelationAddNote(new \StructType\RelationAddNote()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetFields operation/method
 */
if ($relation->RelationGetFields(new \StructType\RelationGetFields()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationExists operation/method
 */
if ($relation->RelationExists(new \StructType\RelationExists()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetAll operation/method
 */
if ($relation->RelationGetAll(new \StructType\RelationGetAll()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetModified operation/method
 */
if ($relation->RelationGetModified(new \StructType\RelationGetModified()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGet operation/method
 */
if ($relation->RelationGet(new \StructType\RelationGet()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetImage operation/method
 */
if ($relation->RelationGetImage(new \StructType\RelationGetImage()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetTelephoneNumbers operation/method
 */
if ($relation->RelationGetTelephoneNumbers(new \StructType\RelationGetTelephoneNumbers()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationSearchByNameAndGetTelephoneNumbers operation/method
 */
if ($relation->RelationSearchByNameAndGetTelephoneNumbers(new \StructType\RelationSearchByNameAndGetTelephoneNumbers()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationSearchByField operation/method
 */
if ($relation->RelationSearchByField(new \StructType\RelationSearchByField()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationSearchByFieldExact operation/method
 */
if ($relation->RelationSearchByFieldExact(new \StructType\RelationSearchByFieldExact()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationSearchByName operation/method
 */
if ($relation->RelationSearchByName(new \StructType\RelationSearchByName()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationSearchByName_V2 operation/method
 */
if ($relation->RelationSearchByName_V2(new \StructType\RelationSearchByName_V2()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationSearchByMark operation/method
 */
if ($relation->RelationSearchByMark(new \StructType\RelationSearchByMark()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationSearchByTelephone operation/method
 */
if ($relation->RelationSearchByTelephone(new \StructType\RelationSearchByTelephone()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetParentRelationships operation/method
 */
if ($relation->RelationGetParentRelationships(new \StructType\RelationGetParentRelationships()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetChildRelationships operation/method
 */
if ($relation->RelationGetChildRelationships(new \StructType\RelationGetChildRelationships()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetChildRelationshipsModified operation/method
 */
if ($relation->RelationGetChildRelationshipsModified(new \StructType\RelationGetChildRelationshipsModified()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetActivities operation/method
 */
if ($relation->RelationGetActivities(new \StructType\RelationGetActivities()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetActivitiesModified operation/method
 */
if ($relation->RelationGetActivitiesModified(new \StructType\RelationGetActivitiesModified()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetActivitiesModified_V2 operation/method
 */
if ($relation->RelationGetActivitiesModified_V2(new \StructType\RelationGetActivitiesModified_V2()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetMarks operation/method
 */
if ($relation->RelationGetMarks(new \StructType\RelationGetMarks()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetMarksModified operation/method
 */
if ($relation->RelationGetMarksModified(new \StructType\RelationGetMarksModified()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetTelephoneBook operation/method
 */
if ($relation->RelationGetTelephoneBook(new \StructType\RelationGetTelephoneBook()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetTelephoneBook_V2 operation/method
 */
if ($relation->RelationGetTelephoneBook_V2(new \StructType\RelationGetTelephoneBook_V2()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetAttachments operation/method
 */
if ($relation->RelationGetAttachments(new \StructType\RelationGetAttachments()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Sample call for RelationGetNotes operation/method
 */
if ($relation->RelationGetNotes(new \StructType\RelationGetNotes()) !== false) {
    print_r($relation->getResult());
} else {
    print_r($relation->getLastError());
}
/**
 * Samples for Product ServiceType
 */
$product = new \ServiceType\Product($options);
/**
 * Sample call for ProductGroupCreate operation/method
 */
if ($product->ProductGroupCreate(new \StructType\ProductGroupCreate()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGroupUpdate operation/method
 */
if ($product->ProductGroupUpdate(new \StructType\ProductGroupUpdate()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductCreate operation/method
 */
if ($product->ProductCreate(new \StructType\ProductCreate()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductCreate_V2 operation/method
 */
if ($product->ProductCreate_V2(new \StructType\ProductCreate_V2()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductUpdate operation/method
 */
if ($product->ProductUpdate(new \StructType\ProductUpdate()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductUpdate_V2 operation/method
 */
if ($product->ProductUpdate_V2(new \StructType\ProductUpdate_V2()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGetVatCodes operation/method
 */
if ($product->ProductGetVatCodes(new \StructType\ProductGetVatCodes()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGetUnits operation/method
 */
if ($product->ProductGetUnits(new \StructType\ProductGetUnits()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGetUnits_V2 operation/method
 */
if ($product->ProductGetUnits_V2(new \StructType\ProductGetUnits_V2()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGetTypes operation/method
 */
if ($product->ProductGetTypes(new \StructType\ProductGetTypes()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGroupExists operation/method
 */
if ($product->ProductGroupExists(new \StructType\ProductGroupExists()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGroupGet operation/method
 */
if ($product->ProductGroupGet(new \StructType\ProductGroupGet()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGroupGetAll operation/method
 */
if ($product->ProductGroupGetAll(new \StructType\ProductGroupGetAll()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductExists operation/method
 */
if ($product->ProductExists(new \StructType\ProductExists()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductSearchByFieldExact operation/method
 */
if ($product->ProductSearchByFieldExact(new \StructType\ProductSearchByFieldExact()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGet operation/method
 */
if ($product->ProductGet(new \StructType\ProductGet()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGet_V2 operation/method
 */
if ($product->ProductGet_V2(new \StructType\ProductGet_V2()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGetAll operation/method
 */
if ($product->ProductGetAll(new \StructType\ProductGetAll()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGetAll_V2 operation/method
 */
if ($product->ProductGetAll_V2(new \StructType\ProductGetAll_V2()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGetAllByGroup operation/method
 */
if ($product->ProductGetAllByGroup(new \StructType\ProductGetAllByGroup()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductGetAllByGroup_V2 operation/method
 */
if ($product->ProductGetAllByGroup_V2(new \StructType\ProductGetAllByGroup_V2()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Sample call for ProductLineGet operation/method
 */
if ($product->ProductLineGet(new \StructType\ProductLineGet()) !== false) {
    print_r($product->getResult());
} else {
    print_r($product->getLastError());
}
/**
 * Samples for Datastore ServiceType
 */
$datastore = new \ServiceType\Datastore($options);
/**
 * Sample call for DatastoreCreateItem operation/method
 */
if ($datastore->DatastoreCreateItem(new \StructType\DatastoreCreateItem()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreCreateItem_V2 operation/method
 */
if ($datastore->DatastoreCreateItem_V2(new \StructType\DatastoreCreateItem_V2()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreCreateItem_V3 operation/method
 */
if ($datastore->DatastoreCreateItem_V3(new \StructType\DatastoreCreateItem_V3()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreUpdateItem operation/method
 */
if ($datastore->DatastoreUpdateItem(new \StructType\DatastoreUpdateItem()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreUpdateItem_V2 operation/method
 */
if ($datastore->DatastoreUpdateItem_V2(new \StructType\DatastoreUpdateItem_V2()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreDeleteItem operation/method
 */
if ($datastore->DatastoreDeleteItem(new \StructType\DatastoreDeleteItem()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreGetItems operation/method
 */
if ($datastore->DatastoreGetItems(new \StructType\DatastoreGetItems()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreGetItems_V2 operation/method
 */
if ($datastore->DatastoreGetItems_V2(new \StructType\DatastoreGetItems_V2()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreGetItems_V3 operation/method
 */
if ($datastore->DatastoreGetItems_V3(new \StructType\DatastoreGetItems_V3()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreGetWithParentItems operation/method
 */
if ($datastore->DatastoreGetWithParentItems(new \StructType\DatastoreGetWithParentItems()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreGetWithParentItems_V2 operation/method
 */
if ($datastore->DatastoreGetWithParentItems_V2(new \StructType\DatastoreGetWithParentItems_V2()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreGetCountries operation/method
 */
if ($datastore->DatastoreGetCountries(new \StructType\DatastoreGetCountries()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Sample call for DatastoreGetSbiCodes operation/method
 */
if ($datastore->DatastoreGetSbiCodes(new \StructType\DatastoreGetSbiCodes()) !== false) {
    print_r($datastore->getResult());
} else {
    print_r($datastore->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
/**
 * Sample call for MarkAdd operation/method
 */
if ($mark->MarkAdd(new \StructType\MarkAdd()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkGetAll operation/method
 */
if ($mark->MarkGetAll(new \StructType\MarkGetAll()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for MarkGetAllV2 operation/method
 */
if ($mark->MarkGetAllV2(new \StructType\MarkGetAllV2()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Notification ServiceType
 */
$notification = new \ServiceType\Notification($options);
/**
 * Sample call for NotificationMarkAsRead operation/method
 */
if ($notification->NotificationMarkAsRead(new \StructType\NotificationMarkAsRead()) !== false) {
    print_r($notification->getResult());
} else {
    print_r($notification->getLastError());
}
/**
 * Sample call for NotificationGetCount operation/method
 */
if ($notification->NotificationGetCount(new \StructType\NotificationGetCount()) !== false) {
    print_r($notification->getResult());
} else {
    print_r($notification->getLastError());
}
/**
 * Samples for User ServiceType
 */
$user = new \ServiceType\User($options);
/**
 * Sample call for UserAddRoles operation/method
 */
if ($user->UserAddRoles(new \StructType\UserAddRoles()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserGetNavigationItems operation/method
 */
if ($user->UserGetNavigationItems(new \StructType\UserGetNavigationItems()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserGetCreateMenuItems operation/method
 */
if ($user->UserGetCreateMenuItems(new \StructType\UserGetCreateMenuItems()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserGetViewDefinitions operation/method
 */
if ($user->UserGetViewDefinitions(new \StructType\UserGetViewDefinitions()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for UserGetDatabases operation/method
 */
if ($user->UserGetDatabases(new \StructType\UserGetDatabases()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Label ServiceType
 */
$label = new \ServiceType\Label($options);
/**
 * Sample call for LabelDelete operation/method
 */
if ($label->LabelDelete(new \StructType\LabelDelete()) !== false) {
    print_r($label->getResult());
} else {
    print_r($label->getLastError());
}
/**
 * Samples for Mobile ServiceType
 */
$mobile = new \ServiceType\Mobile($options);
/**
 * Sample call for MobileLogError operation/method
 */
if ($mobile->MobileLogError(new \StructType\MobileLogError()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Sample call for MobileHasAccess operation/method
 */
if ($mobile->MobileHasAccess(new \StructType\MobileHasAccess()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Sample call for MobileShouldUpdateApp operation/method
 */
if ($mobile->MobileShouldUpdateApp(new \StructType\MobileShouldUpdateApp()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Sample call for MobileStoreDeviceId operation/method
 */
if ($mobile->MobileStoreDeviceId(new \StructType\MobileStoreDeviceId()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Sample call for MobileRemoveDeviceId operation/method
 */
if ($mobile->MobileRemoveDeviceId(new \StructType\MobileRemoveDeviceId()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Sample call for MobileGetTranslations operation/method
 */
if ($mobile->MobileGetTranslations(new \StructType\MobileGetTranslations()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Sample call for MobileCreateAccount operation/method
 */
if ($mobile->MobileCreateAccount(new \StructType\MobileCreateAccount()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Sample call for MobileGetCreateAccountDatastore operation/method
 */
if ($mobile->MobileGetCreateAccountDatastore(new \StructType\MobileGetCreateAccountDatastore()) !== false) {
    print_r($mobile->getResult());
} else {
    print_r($mobile->getLastError());
}
/**
 * Samples for Has ServiceType
 */
$has = new \ServiceType\Has($options);
/**
 * Sample call for HasAccess operation/method
 */
if ($has->HasAccess(new \StructType\HasAccess()) !== false) {
    print_r($has->getResult());
} else {
    print_r($has->getLastError());
}
/**
 * Samples for Api ServiceType
 */
$api = new \ServiceType\Api($options);
/**
 * Sample call for ApiGetVersion operation/method
 */
if ($api->ApiGetVersion(new \StructType\ApiGetVersion()) !== false) {
    print_r($api->getResult());
} else {
    print_r($api->getLastError());
}
/**
 * Sample call for ApiGetCalls operation/method
 */
if ($api->ApiGetCalls(new \StructType\ApiGetCalls()) !== false) {
    print_r($api->getResult());
} else {
    print_r($api->getLastError());
}
/**
 * Samples for Database ServiceType
 */
$database = new \ServiceType\Database($options);
/**
 * Sample call for DatabaseHasAccess operation/method
 */
if ($database->DatabaseHasAccess(new \StructType\DatabaseHasAccess()) !== false) {
    print_r($database->getResult());
} else {
    print_r($database->getLastError());
}
/**
 * Samples for Enumeration ServiceType
 */
$enumeration = new \ServiceType\Enumeration($options);
/**
 * Sample call for EnumerationGetItems operation/method
 */
if ($enumeration->EnumerationGetItems(new \StructType\EnumerationGetItems()) !== false) {
    print_r($enumeration->getResult());
} else {
    print_r($enumeration->getLastError());
}
/**
 * Samples for Entity ServiceType
 */
$entity = new \ServiceType\Entity($options);
/**
 * Sample call for EntityTypeGet operation/method
 */
if ($entity->EntityTypeGet(new \StructType\EntityTypeGet()) !== false) {
    print_r($entity->getResult());
} else {
    print_r($entity->getLastError());
}
/**
 * Sample call for EntityTypeGetAll operation/method
 */
if ($entity->EntityTypeGetAll(new \StructType\EntityTypeGetAll()) !== false) {
    print_r($entity->getResult());
} else {
    print_r($entity->getLastError());
}
/**
 * Sample call for EntityTypeGetFields operation/method
 */
if ($entity->EntityTypeGetFields(new \StructType\EntityTypeGetFields()) !== false) {
    print_r($entity->getResult());
} else {
    print_r($entity->getLastError());
}
/**
 * Sample call for EntityTypeGetFields_V2 operation/method
 */
if ($entity->EntityTypeGetFields_V2(new \StructType\EntityTypeGetFields_V2()) !== false) {
    print_r($entity->getResult());
} else {
    print_r($entity->getLastError());
}
/**
 * Samples for Workflow ServiceType
 */
$workflow = new \ServiceType\Workflow($options);
/**
 * Sample call for WorkflowGet operation/method
 */
if ($workflow->WorkflowGet(new \StructType\WorkflowGet()) !== false) {
    print_r($workflow->getResult());
} else {
    print_r($workflow->getLastError());
}
/**
 * Sample call for WorkflowGetAll operation/method
 */
if ($workflow->WorkflowGetAll(new \StructType\WorkflowGetAll()) !== false) {
    print_r($workflow->getResult());
} else {
    print_r($workflow->getLastError());
}
/**
 * Sample call for WorkflowStepGet operation/method
 */
if ($workflow->WorkflowStepGet(new \StructType\WorkflowStepGet()) !== false) {
    print_r($workflow->getResult());
} else {
    print_r($workflow->getLastError());
}
/**
 * Sample call for WorkflowStepGetAll operation/method
 */
if ($workflow->WorkflowStepGetAll(new \StructType\WorkflowStepGetAll()) !== false) {
    print_r($workflow->getResult());
} else {
    print_r($workflow->getLastError());
}
/**
 * Sample call for WorkflowGetQueues operation/method
 */
if ($workflow->WorkflowGetQueues(new \StructType\WorkflowGetQueues()) !== false) {
    print_r($workflow->getResult());
} else {
    print_r($workflow->getLastError());
}
/**
 * Samples for Field ServiceType
 */
$field = new \ServiceType\Field($options);
/**
 * Sample call for FieldGet operation/method
 */
if ($field->FieldGet(new \StructType\FieldGet()) !== false) {
    print_r($field->getResult());
} else {
    print_r($field->getLastError());
}
/**
 * Samples for Users ServiceType
 */
$users = new \ServiceType\Users($options);
/**
 * Sample call for UsersGetActive operation/method
 */
if ($users->UsersGetActive(new \StructType\UsersGetActive()) !== false) {
    print_r($users->getResult());
} else {
    print_r($users->getLastError());
}
/**
 * Sample call for UsersGetRoles operation/method
 */
if ($users->UsersGetRoles(new \StructType\UsersGetRoles()) !== false) {
    print_r($users->getResult());
} else {
    print_r($users->getLastError());
}
/**
 * Sample call for UsersGetLanguage operation/method
 */
if ($users->UsersGetLanguage(new \StructType\UsersGetLanguage()) !== false) {
    print_r($users->getResult());
} else {
    print_r($users->getLastError());
}
/**
 * Sample call for UsersSetLanguage operation/method
 */
if ($users->UsersSetLanguage(new \StructType\UsersSetLanguage()) !== false) {
    print_r($users->getResult());
} else {
    print_r($users->getLastError());
}
/**
 * Samples for Language ServiceType
 */
$language = new \ServiceType\Language($options);
/**
 * Sample call for LanguageGetAll operation/method
 */
if ($language->LanguageGetAll(new \StructType\LanguageGetAll()) !== false) {
    print_r($language->getResult());
} else {
    print_r($language->getLastError());
}
/**
 * Samples for Role ServiceType
 */
$role = new \ServiceType\Role($options);
/**
 * Sample call for RoleGetAll operation/method
 */
if ($role->RoleGetAll(new \StructType\RoleGetAll()) !== false) {
    print_r($role->getResult());
} else {
    print_r($role->getLastError());
}
/**
 * Sample call for RoleGetObjectRights operation/method
 */
if ($role->RoleGetObjectRights(new \StructType\RoleGetObjectRights()) !== false) {
    print_r($role->getResult());
} else {
    print_r($role->getLastError());
}
/**
 * Samples for Campaign ServiceType
 */
$campaign = new \ServiceType\Campaign($options);
/**
 * Sample call for CampaignMarkGetAll operation/method
 */
if ($campaign->CampaignMarkGetAll(new \StructType\CampaignMarkGetAll()) !== false) {
    print_r($campaign->getResult());
} else {
    print_r($campaign->getLastError());
}
/**
 * Samples for Parameter ServiceType
 */
$parameter = new \ServiceType\Parameter($options);
/**
 * Sample call for ParameterGet operation/method
 */
if ($parameter->ParameterGet(new \StructType\ParameterGet()) !== false) {
    print_r($parameter->getResult());
} else {
    print_r($parameter->getLastError());
}
/**
 * Samples for System ServiceType
 */
$system = new \ServiceType\System($options);
/**
 * Sample call for SystemDatastoreGetItems operation/method
 */
if ($system->SystemDatastoreGetItems(new \StructType\SystemDatastoreGetItems()) !== false) {
    print_r($system->getResult());
} else {
    print_r($system->getLastError());
}
/**
 * Samples for Notifications ServiceType
 */
$notifications = new \ServiceType\Notifications($options);
/**
 * Sample call for NotificationsGet operation/method
 */
if ($notifications->NotificationsGet(new \StructType\NotificationsGet()) !== false) {
    print_r($notifications->getResult());
} else {
    print_r($notifications->getLastError());
}
