<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Workflow StructType
 * @subpackage Structs
 */
class Workflow extends AbstractStructBase
{
    /**
     * The WorkflowName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkflowName;
    /**
     * The WorkflowStepName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkflowStepName;
    /**
     * The WorkflowQueueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkflowQueueId;
    /**
     * Constructor method for Workflow
     * @uses Workflow::setWorkflowName()
     * @uses Workflow::setWorkflowStepName()
     * @uses Workflow::setWorkflowQueueId()
     * @param string $workflowName
     * @param string $workflowStepName
     * @param string $workflowQueueId
     */
    public function __construct($workflowName = null, $workflowStepName = null, $workflowQueueId = null)
    {
        $this
            ->setWorkflowName($workflowName)
            ->setWorkflowStepName($workflowStepName)
            ->setWorkflowQueueId($workflowQueueId);
    }
    /**
     * Get WorkflowName value
     * @return string|null
     */
    public function getWorkflowName()
    {
        return $this->WorkflowName;
    }
    /**
     * Set WorkflowName value
     * @param string $workflowName
     * @return \StructType\Workflow
     */
    public function setWorkflowName($workflowName = null)
    {
        // validation for constraint: string
        if (!is_null($workflowName) && !is_string($workflowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workflowName, true), gettype($workflowName)), __LINE__);
        }
        $this->WorkflowName = $workflowName;
        return $this;
    }
    /**
     * Get WorkflowStepName value
     * @return string|null
     */
    public function getWorkflowStepName()
    {
        return $this->WorkflowStepName;
    }
    /**
     * Set WorkflowStepName value
     * @param string $workflowStepName
     * @return \StructType\Workflow
     */
    public function setWorkflowStepName($workflowStepName = null)
    {
        // validation for constraint: string
        if (!is_null($workflowStepName) && !is_string($workflowStepName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workflowStepName, true), gettype($workflowStepName)), __LINE__);
        }
        $this->WorkflowStepName = $workflowStepName;
        return $this;
    }
    /**
     * Get WorkflowQueueId value
     * @return string|null
     */
    public function getWorkflowQueueId()
    {
        return $this->WorkflowQueueId;
    }
    /**
     * Set WorkflowQueueId value
     * @param string $workflowQueueId
     * @return \StructType\Workflow
     */
    public function setWorkflowQueueId($workflowQueueId = null)
    {
        // validation for constraint: string
        if (!is_null($workflowQueueId) && !is_string($workflowQueueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workflowQueueId, true), gettype($workflowQueueId)), __LINE__);
        }
        $this->WorkflowQueueId = $workflowQueueId;
        return $this;
    }
}
