<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserGetViewDefinitions StructType
 * @subpackage Structs
 */
class UserGetViewDefinitions extends AbstractStructBase
{
    /**
     * The entryPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $entryPoint;
    /**
     * The baseEntityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $baseEntityType;
    /**
     * The entityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $entityId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for UserGetViewDefinitions
     * @uses UserGetViewDefinitions::setEntryPoint()
     * @uses UserGetViewDefinitions::setBaseEntityType()
     * @uses UserGetViewDefinitions::setEntityId()
     * @uses UserGetViewDefinitions::setCredentials()
     * @param string $entryPoint
     * @param string $baseEntityType
     * @param string $entityId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($entryPoint = null, $baseEntityType = null, $entityId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setEntryPoint($entryPoint)
            ->setBaseEntityType($baseEntityType)
            ->setEntityId($entityId)
            ->setCredentials($credentials);
    }
    /**
     * Get entryPoint value
     * @return string
     */
    public function getEntryPoint()
    {
        return $this->entryPoint;
    }
    /**
     * Set entryPoint value
     * @uses \EnumType\ViewEntryPoint::valueIsValid()
     * @uses \EnumType\ViewEntryPoint::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entryPoint
     * @return \StructType\UserGetViewDefinitions
     */
    public function setEntryPoint($entryPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ViewEntryPoint::valueIsValid($entryPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ViewEntryPoint', is_array($entryPoint) ? implode(', ', $entryPoint) : var_export($entryPoint, true), implode(', ', \EnumType\ViewEntryPoint::getValidValues())), __LINE__);
        }
        $this->entryPoint = $entryPoint;
        return $this;
    }
    /**
     * Get baseEntityType value
     * @return string
     */
    public function getBaseEntityType()
    {
        return $this->baseEntityType;
    }
    /**
     * Set baseEntityType value
     * @uses \EnumType\BaseEntityType::valueIsValid()
     * @uses \EnumType\BaseEntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseEntityType
     * @return \StructType\UserGetViewDefinitions
     */
    public function setBaseEntityType($baseEntityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BaseEntityType::valueIsValid($baseEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BaseEntityType', is_array($baseEntityType) ? implode(', ', $baseEntityType) : var_export($baseEntityType, true), implode(', ', \EnumType\BaseEntityType::getValidValues())), __LINE__);
        }
        $this->baseEntityType = $baseEntityType;
        return $this;
    }
    /**
     * Get entityId value
     * @return string
     */
    public function getEntityId()
    {
        return $this->entityId;
    }
    /**
     * Set entityId value
     * @param string $entityId
     * @return \StructType\UserGetViewDefinitions
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        $this->entityId = $entityId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\UserGetViewDefinitions
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
