<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserAddRoles StructType
 * @subpackage Structs
 */
class UserAddRoles extends AbstractStructBase
{
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $userId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The roleIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuid
     */
    public $roleIds;
    /**
     * Constructor method for UserAddRoles
     * @uses UserAddRoles::setUserId()
     * @uses UserAddRoles::setCredentials()
     * @uses UserAddRoles::setRoleIds()
     * @param string $userId
     * @param \StructType\ApiCredentials $credentials
     * @param \ArrayType\ArrayOfGuid $roleIds
     */
    public function __construct($userId = null, \StructType\ApiCredentials $credentials = null, \ArrayType\ArrayOfGuid $roleIds = null)
    {
        $this
            ->setUserId($userId)
            ->setCredentials($credentials)
            ->setRoleIds($roleIds);
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\UserAddRoles
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\UserAddRoles
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get roleIds value
     * @return \ArrayType\ArrayOfGuid|null
     */
    public function getRoleIds()
    {
        return $this->roleIds;
    }
    /**
     * Set roleIds value
     * @param \ArrayType\ArrayOfGuid $roleIds
     * @return \StructType\UserAddRoles
     */
    public function setRoleIds(\ArrayType\ArrayOfGuid $roleIds = null)
    {
        $this->roleIds = $roleIds;
        return $this;
    }
}
