<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemDatastoreGetItems StructType
 * @subpackage Structs
 */
class SystemDatastoreGetItems extends AbstractStructBase
{
    /**
     * The systemDatastoreType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $systemDatastoreType;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for SystemDatastoreGetItems
     * @uses SystemDatastoreGetItems::setSystemDatastoreType()
     * @uses SystemDatastoreGetItems::setCredentials()
     * @param string $systemDatastoreType
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($systemDatastoreType = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setSystemDatastoreType($systemDatastoreType)
            ->setCredentials($credentials);
    }
    /**
     * Get systemDatastoreType value
     * @return string
     */
    public function getSystemDatastoreType()
    {
        return $this->systemDatastoreType;
    }
    /**
     * Set systemDatastoreType value
     * @uses \EnumType\SystemDatastoreType::valueIsValid()
     * @uses \EnumType\SystemDatastoreType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $systemDatastoreType
     * @return \StructType\SystemDatastoreGetItems
     */
    public function setSystemDatastoreType($systemDatastoreType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SystemDatastoreType::valueIsValid($systemDatastoreType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SystemDatastoreType', is_array($systemDatastoreType) ? implode(', ', $systemDatastoreType) : var_export($systemDatastoreType, true), implode(', ', \EnumType\SystemDatastoreType::getValidValues())), __LINE__);
        }
        $this->systemDatastoreType = $systemDatastoreType;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\SystemDatastoreGetItems
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
