<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipSearchByFieldResult StructType
 * @subpackage Structs
 */
class RelationshipSearchByFieldResult extends PvApiResult
{
    /**
     * The Relationships
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvRelationshipData
     */
    public $Relationships;
    /**
     * The ErrorInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorInformation;
    /**
     * Constructor method for RelationshipSearchByFieldResult
     * @uses RelationshipSearchByFieldResult::setRelationships()
     * @uses RelationshipSearchByFieldResult::setErrorInformation()
     * @param \ArrayType\ArrayOfPvRelationshipData $relationships
     * @param string $errorInformation
     */
    public function __construct(\ArrayType\ArrayOfPvRelationshipData $relationships = null, $errorInformation = null)
    {
        $this
            ->setRelationships($relationships)
            ->setErrorInformation($errorInformation);
    }
    /**
     * Get Relationships value
     * @return \ArrayType\ArrayOfPvRelationshipData|null
     */
    public function getRelationships()
    {
        return $this->Relationships;
    }
    /**
     * Set Relationships value
     * @param \ArrayType\ArrayOfPvRelationshipData $relationships
     * @return \StructType\RelationshipSearchByFieldResult
     */
    public function setRelationships(\ArrayType\ArrayOfPvRelationshipData $relationships = null)
    {
        $this->Relationships = $relationships;
        return $this;
    }
    /**
     * Get ErrorInformation value
     * @return string|null
     */
    public function getErrorInformation()
    {
        return $this->ErrorInformation;
    }
    /**
     * Set ErrorInformation value
     * @param string $errorInformation
     * @return \StructType\RelationshipSearchByFieldResult
     */
    public function setErrorInformation($errorInformation = null)
    {
        // validation for constraint: string
        if (!is_null($errorInformation) && !is_string($errorInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorInformation, true), gettype($errorInformation)), __LINE__);
        }
        $this->ErrorInformation = $errorInformation;
        return $this;
    }
}
