<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipGetFields StructType
 * @subpackage Structs
 */
class RelationshipGetFields extends AbstractStructBase
{
    /**
     * The relationshipEntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationshipEntityTypeId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for RelationshipGetFields
     * @uses RelationshipGetFields::setRelationshipEntityTypeId()
     * @uses RelationshipGetFields::setCredentials()
     * @param string $relationshipEntityTypeId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($relationshipEntityTypeId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setRelationshipEntityTypeId($relationshipEntityTypeId)
            ->setCredentials($credentials);
    }
    /**
     * Get relationshipEntityTypeId value
     * @return string
     */
    public function getRelationshipEntityTypeId()
    {
        return $this->relationshipEntityTypeId;
    }
    /**
     * Set relationshipEntityTypeId value
     * @param string $relationshipEntityTypeId
     * @return \StructType\RelationshipGetFields
     */
    public function setRelationshipEntityTypeId($relationshipEntityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipEntityTypeId) && !is_string($relationshipEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipEntityTypeId, true), gettype($relationshipEntityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationshipEntityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationshipEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationshipEntityTypeId, true)), __LINE__);
        }
        $this->relationshipEntityTypeId = $relationshipEntityTypeId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationshipGetFields
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
