<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipCreateResult StructType
 * @subpackage Structs
 */
class RelationshipCreateResult extends PvApiResult
{
    /**
     * The Relationship
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvRelationshipData
     */
    public $Relationship;
    /**
     * The ErrorInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorInformation;
    /**
     * Constructor method for RelationshipCreateResult
     * @uses RelationshipCreateResult::setRelationship()
     * @uses RelationshipCreateResult::setErrorInformation()
     * @param \StructType\PvRelationshipData $relationship
     * @param string $errorInformation
     */
    public function __construct(\StructType\PvRelationshipData $relationship = null, $errorInformation = null)
    {
        $this
            ->setRelationship($relationship)
            ->setErrorInformation($errorInformation);
    }
    /**
     * Get Relationship value
     * @return \StructType\PvRelationshipData|null
     */
    public function getRelationship()
    {
        return $this->Relationship;
    }
    /**
     * Set Relationship value
     * @param \StructType\PvRelationshipData $relationship
     * @return \StructType\RelationshipCreateResult
     */
    public function setRelationship(\StructType\PvRelationshipData $relationship = null)
    {
        $this->Relationship = $relationship;
        return $this;
    }
    /**
     * Get ErrorInformation value
     * @return string|null
     */
    public function getErrorInformation()
    {
        return $this->ErrorInformation;
    }
    /**
     * Set ErrorInformation value
     * @param string $errorInformation
     * @return \StructType\RelationshipCreateResult
     */
    public function setErrorInformation($errorInformation = null)
    {
        // validation for constraint: string
        if (!is_null($errorInformation) && !is_string($errorInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorInformation, true), gettype($errorInformation)), __LINE__);
        }
        $this->ErrorInformation = $errorInformation;
        return $this;
    }
}
