<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipAddLineResult StructType
 * @subpackage Structs
 */
class RelationshipAddLineResult extends PvApiResult
{
    /**
     * The LineData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvLineData
     */
    public $LineData;
    /**
     * The ErrorInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorInformation;
    /**
     * Constructor method for RelationshipAddLineResult
     * @uses RelationshipAddLineResult::setLineData()
     * @uses RelationshipAddLineResult::setErrorInformation()
     * @param \StructType\PvLineData $lineData
     * @param string $errorInformation
     */
    public function __construct(\StructType\PvLineData $lineData = null, $errorInformation = null)
    {
        $this
            ->setLineData($lineData)
            ->setErrorInformation($errorInformation);
    }
    /**
     * Get LineData value
     * @return \StructType\PvLineData|null
     */
    public function getLineData()
    {
        return $this->LineData;
    }
    /**
     * Set LineData value
     * @param \StructType\PvLineData $lineData
     * @return \StructType\RelationshipAddLineResult
     */
    public function setLineData(\StructType\PvLineData $lineData = null)
    {
        $this->LineData = $lineData;
        return $this;
    }
    /**
     * Get ErrorInformation value
     * @return string|null
     */
    public function getErrorInformation()
    {
        return $this->ErrorInformation;
    }
    /**
     * Set ErrorInformation value
     * @param string $errorInformation
     * @return \StructType\RelationshipAddLineResult
     */
    public function setErrorInformation($errorInformation = null)
    {
        // validation for constraint: string
        if (!is_null($errorInformation) && !is_string($errorInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorInformation, true), gettype($errorInformation)), __LINE__);
        }
        $this->ErrorInformation = $errorInformation;
        return $this;
    }
}
