<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationGetResult StructType
 * @subpackage Structs
 */
class RelationGetResult extends PvApiResult
{
    /**
     * The Relation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvRelationData
     */
    public $Relation;
    /**
     * The Counters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvCounterData
     */
    public $Counters;
    /**
     * Constructor method for RelationGetResult
     * @uses RelationGetResult::setRelation()
     * @uses RelationGetResult::setCounters()
     * @param \StructType\PvRelationData $relation
     * @param \ArrayType\ArrayOfPvCounterData $counters
     */
    public function __construct(\StructType\PvRelationData $relation = null, \ArrayType\ArrayOfPvCounterData $counters = null)
    {
        $this
            ->setRelation($relation)
            ->setCounters($counters);
    }
    /**
     * Get Relation value
     * @return \StructType\PvRelationData|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param \StructType\PvRelationData $relation
     * @return \StructType\RelationGetResult
     */
    public function setRelation(\StructType\PvRelationData $relation = null)
    {
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get Counters value
     * @return \ArrayType\ArrayOfPvCounterData|null
     */
    public function getCounters()
    {
        return $this->Counters;
    }
    /**
     * Set Counters value
     * @param \ArrayType\ArrayOfPvCounterData $counters
     * @return \StructType\RelationGetResult
     */
    public function setCounters(\ArrayType\ArrayOfPvCounterData $counters = null)
    {
        $this->Counters = $counters;
        return $this;
    }
}
