<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationGetMarksResult StructType
 * @subpackage Structs
 */
class RelationGetMarksResult extends PvApiResult
{
    /**
     * The Relation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvRelationData
     */
    public $Relation;
    /**
     * The RelationshipMarks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvRelationshipMarkData
     */
    public $RelationshipMarks;
    /**
     * Constructor method for RelationGetMarksResult
     * @uses RelationGetMarksResult::setRelation()
     * @uses RelationGetMarksResult::setRelationshipMarks()
     * @param \StructType\PvRelationData $relation
     * @param \ArrayType\ArrayOfPvRelationshipMarkData $relationshipMarks
     */
    public function __construct(\StructType\PvRelationData $relation = null, \ArrayType\ArrayOfPvRelationshipMarkData $relationshipMarks = null)
    {
        $this
            ->setRelation($relation)
            ->setRelationshipMarks($relationshipMarks);
    }
    /**
     * Get Relation value
     * @return \StructType\PvRelationData|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param \StructType\PvRelationData $relation
     * @return \StructType\RelationGetMarksResult
     */
    public function setRelation(\StructType\PvRelationData $relation = null)
    {
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get RelationshipMarks value
     * @return \ArrayType\ArrayOfPvRelationshipMarkData|null
     */
    public function getRelationshipMarks()
    {
        return $this->RelationshipMarks;
    }
    /**
     * Set RelationshipMarks value
     * @param \ArrayType\ArrayOfPvRelationshipMarkData $relationshipMarks
     * @return \StructType\RelationGetMarksResult
     */
    public function setRelationshipMarks(\ArrayType\ArrayOfPvRelationshipMarkData $relationshipMarks = null)
    {
        $this->RelationshipMarks = $relationshipMarks;
        return $this;
    }
}
