<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationGetFields StructType
 * @subpackage Structs
 */
class RelationGetFields extends AbstractStructBase
{
    /**
     * The baseRelationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $baseRelationType;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for RelationGetFields
     * @uses RelationGetFields::setBaseRelationType()
     * @uses RelationGetFields::setCredentials()
     * @param string $baseRelationType
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($baseRelationType = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setBaseRelationType($baseRelationType)
            ->setCredentials($credentials);
    }
    /**
     * Get baseRelationType value
     * @return string
     */
    public function getBaseRelationType()
    {
        return $this->baseRelationType;
    }
    /**
     * Set baseRelationType value
     * @uses \EnumType\BaseRelationType::valueIsValid()
     * @uses \EnumType\BaseRelationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseRelationType
     * @return \StructType\RelationGetFields
     */
    public function setBaseRelationType($baseRelationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BaseRelationType::valueIsValid($baseRelationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BaseRelationType', is_array($baseRelationType) ? implode(', ', $baseRelationType) : var_export($baseRelationType, true), implode(', ', \EnumType\BaseRelationType::getValidValues())), __LINE__);
        }
        $this->baseRelationType = $baseRelationType;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationGetFields
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
