<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationGetChildRelationshipsModified StructType
 * @subpackage Structs
 */
class RelationGetChildRelationshipsModified extends AbstractStructBase
{
    /**
     * The relationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationId;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $from;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $to;
    /**
     * The includeFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeFields;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for RelationGetChildRelationshipsModified
     * @uses RelationGetChildRelationshipsModified::setRelationId()
     * @uses RelationGetChildRelationshipsModified::setFrom()
     * @uses RelationGetChildRelationshipsModified::setTo()
     * @uses RelationGetChildRelationshipsModified::setIncludeFields()
     * @uses RelationGetChildRelationshipsModified::setCredentials()
     * @param string $relationId
     * @param string $from
     * @param string $to
     * @param bool $includeFields
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($relationId = null, $from = null, $to = null, $includeFields = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setRelationId($relationId)
            ->setFrom($from)
            ->setTo($to)
            ->setIncludeFields($includeFields)
            ->setCredentials($credentials);
    }
    /**
     * Get relationId value
     * @return string
     */
    public function getRelationId()
    {
        return $this->relationId;
    }
    /**
     * Set relationId value
     * @param string $relationId
     * @return \StructType\RelationGetChildRelationshipsModified
     */
    public function setRelationId($relationId = null)
    {
        // validation for constraint: string
        if (!is_null($relationId) && !is_string($relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationId, true), gettype($relationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationId, true)), __LINE__);
        }
        $this->relationId = $relationId;
        return $this;
    }
    /**
     * Get from value
     * @return string
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\RelationGetChildRelationshipsModified
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return string
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param string $to
     * @return \StructType\RelationGetChildRelationshipsModified
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
    /**
     * Get includeFields value
     * @return bool
     */
    public function getIncludeFields()
    {
        return $this->includeFields;
    }
    /**
     * Set includeFields value
     * @param bool $includeFields
     * @return \StructType\RelationGetChildRelationshipsModified
     */
    public function setIncludeFields($includeFields = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFields) && !is_bool($includeFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFields, true), gettype($includeFields)), __LINE__);
        }
        $this->includeFields = $includeFields;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationGetChildRelationshipsModified
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
