<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationGetAll StructType
 * @subpackage Structs
 */
class RelationGetAll extends AbstractStructBase
{
    /**
     * The pageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageNumber;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageSize;
    /**
     * The includeFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeFields;
    /**
     * The includeCounters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeCounters;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for RelationGetAll
     * @uses RelationGetAll::setPageNumber()
     * @uses RelationGetAll::setPageSize()
     * @uses RelationGetAll::setIncludeFields()
     * @uses RelationGetAll::setIncludeCounters()
     * @uses RelationGetAll::setCredentials()
     * @param int $pageNumber
     * @param int $pageSize
     * @param bool $includeFields
     * @param bool $includeCounters
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($pageNumber = null, $pageSize = null, $includeFields = null, $includeCounters = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setPageNumber($pageNumber)
            ->setPageSize($pageSize)
            ->setIncludeFields($includeFields)
            ->setIncludeCounters($includeCounters)
            ->setCredentials($credentials);
    }
    /**
     * Get pageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->pageNumber;
    }
    /**
     * Set pageNumber value
     * @param int $pageNumber
     * @return \StructType\RelationGetAll
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->pageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\RelationGetAll
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get includeFields value
     * @return bool
     */
    public function getIncludeFields()
    {
        return $this->includeFields;
    }
    /**
     * Set includeFields value
     * @param bool $includeFields
     * @return \StructType\RelationGetAll
     */
    public function setIncludeFields($includeFields = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFields) && !is_bool($includeFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFields, true), gettype($includeFields)), __LINE__);
        }
        $this->includeFields = $includeFields;
        return $this;
    }
    /**
     * Get includeCounters value
     * @return bool
     */
    public function getIncludeCounters()
    {
        return $this->includeCounters;
    }
    /**
     * Set includeCounters value
     * @param bool $includeCounters
     * @return \StructType\RelationGetAll
     */
    public function setIncludeCounters($includeCounters = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCounters) && !is_bool($includeCounters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCounters, true), gettype($includeCounters)), __LINE__);
        }
        $this->includeCounters = $includeCounters;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationGetAll
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
