<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationGet StructType
 * @subpackage Structs
 */
class RelationGet extends AbstractStructBase
{
    /**
     * The relationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationId;
    /**
     * The includeFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeFields;
    /**
     * The includeCounters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeCounters;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for RelationGet
     * @uses RelationGet::setRelationId()
     * @uses RelationGet::setIncludeFields()
     * @uses RelationGet::setIncludeCounters()
     * @uses RelationGet::setCredentials()
     * @param string $relationId
     * @param bool $includeFields
     * @param bool $includeCounters
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($relationId = null, $includeFields = null, $includeCounters = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setRelationId($relationId)
            ->setIncludeFields($includeFields)
            ->setIncludeCounters($includeCounters)
            ->setCredentials($credentials);
    }
    /**
     * Get relationId value
     * @return string
     */
    public function getRelationId()
    {
        return $this->relationId;
    }
    /**
     * Set relationId value
     * @param string $relationId
     * @return \StructType\RelationGet
     */
    public function setRelationId($relationId = null)
    {
        // validation for constraint: string
        if (!is_null($relationId) && !is_string($relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationId, true), gettype($relationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationId, true)), __LINE__);
        }
        $this->relationId = $relationId;
        return $this;
    }
    /**
     * Get includeFields value
     * @return bool
     */
    public function getIncludeFields()
    {
        return $this->includeFields;
    }
    /**
     * Set includeFields value
     * @param bool $includeFields
     * @return \StructType\RelationGet
     */
    public function setIncludeFields($includeFields = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFields) && !is_bool($includeFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFields, true), gettype($includeFields)), __LINE__);
        }
        $this->includeFields = $includeFields;
        return $this;
    }
    /**
     * Get includeCounters value
     * @return bool
     */
    public function getIncludeCounters()
    {
        return $this->includeCounters;
    }
    /**
     * Set includeCounters value
     * @param bool $includeCounters
     * @return \StructType\RelationGet
     */
    public function setIncludeCounters($includeCounters = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCounters) && !is_bool($includeCounters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCounters, true), gettype($includeCounters)), __LINE__);
        }
        $this->includeCounters = $includeCounters;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationGet
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
