<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationDeleteAttachment StructType
 * @subpackage Structs
 */
class RelationDeleteAttachment extends AbstractStructBase
{
    /**
     * The relationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationId;
    /**
     * The attachmentId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $attachmentId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for RelationDeleteAttachment
     * @uses RelationDeleteAttachment::setRelationId()
     * @uses RelationDeleteAttachment::setAttachmentId()
     * @uses RelationDeleteAttachment::setCredentials()
     * @param string $relationId
     * @param string $attachmentId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($relationId = null, $attachmentId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setRelationId($relationId)
            ->setAttachmentId($attachmentId)
            ->setCredentials($credentials);
    }
    /**
     * Get relationId value
     * @return string
     */
    public function getRelationId()
    {
        return $this->relationId;
    }
    /**
     * Set relationId value
     * @param string $relationId
     * @return \StructType\RelationDeleteAttachment
     */
    public function setRelationId($relationId = null)
    {
        // validation for constraint: string
        if (!is_null($relationId) && !is_string($relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationId, true), gettype($relationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationId, true)), __LINE__);
        }
        $this->relationId = $relationId;
        return $this;
    }
    /**
     * Get attachmentId value
     * @return string
     */
    public function getAttachmentId()
    {
        return $this->attachmentId;
    }
    /**
     * Set attachmentId value
     * @param string $attachmentId
     * @return \StructType\RelationDeleteAttachment
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentId) && !is_string($attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($attachmentId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($attachmentId, true)), __LINE__);
        }
        $this->attachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\RelationDeleteAttachment
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
