<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationCreateResult StructType
 * @subpackage Structs
 */
class RelationCreateResult extends PvApiResult
{
    /**
     * The Relationship
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvRelationshipData
     */
    public $Relationship;
    /**
     * The Relation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvRelationData
     */
    public $Relation;
    /**
     * The ErrorInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorInformation;
    /**
     * Constructor method for RelationCreateResult
     * @uses RelationCreateResult::setRelationship()
     * @uses RelationCreateResult::setRelation()
     * @uses RelationCreateResult::setErrorInformation()
     * @param \StructType\PvRelationshipData $relationship
     * @param \StructType\PvRelationData $relation
     * @param string $errorInformation
     */
    public function __construct(\StructType\PvRelationshipData $relationship = null, \StructType\PvRelationData $relation = null, $errorInformation = null)
    {
        $this
            ->setRelationship($relationship)
            ->setRelation($relation)
            ->setErrorInformation($errorInformation);
    }
    /**
     * Get Relationship value
     * @return \StructType\PvRelationshipData|null
     */
    public function getRelationship()
    {
        return $this->Relationship;
    }
    /**
     * Set Relationship value
     * @param \StructType\PvRelationshipData $relationship
     * @return \StructType\RelationCreateResult
     */
    public function setRelationship(\StructType\PvRelationshipData $relationship = null)
    {
        $this->Relationship = $relationship;
        return $this;
    }
    /**
     * Get Relation value
     * @return \StructType\PvRelationData|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param \StructType\PvRelationData $relation
     * @return \StructType\RelationCreateResult
     */
    public function setRelation(\StructType\PvRelationData $relation = null)
    {
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get ErrorInformation value
     * @return string|null
     */
    public function getErrorInformation()
    {
        return $this->ErrorInformation;
    }
    /**
     * Set ErrorInformation value
     * @param string $errorInformation
     * @return \StructType\RelationCreateResult
     */
    public function setErrorInformation($errorInformation = null)
    {
        // validation for constraint: string
        if (!is_null($errorInformation) && !is_string($errorInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorInformation, true), gettype($errorInformation)), __LINE__);
        }
        $this->ErrorInformation = $errorInformation;
        return $this;
    }
}
