<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvViewDefinitionData StructType
 * @subpackage Structs
 */
class PvViewDefinitionData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The ViewEntryPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ViewEntryPoint;
    /**
     * The BaseEntityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaseEntityType;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityId;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDefault;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Sql
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sql;
    /**
     * The SortingColumn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortingColumn;
    /**
     * Constructor method for PvViewDefinitionData
     * @uses PvViewDefinitionData::setId()
     * @uses PvViewDefinitionData::setViewEntryPoint()
     * @uses PvViewDefinitionData::setBaseEntityType()
     * @uses PvViewDefinitionData::setEntityId()
     * @uses PvViewDefinitionData::setIsDefault()
     * @uses PvViewDefinitionData::setName()
     * @uses PvViewDefinitionData::setSql()
     * @uses PvViewDefinitionData::setSortingColumn()
     * @param string $id
     * @param string $viewEntryPoint
     * @param string $baseEntityType
     * @param string $entityId
     * @param bool $isDefault
     * @param string $name
     * @param string $sql
     * @param string $sortingColumn
     */
    public function __construct($id = null, $viewEntryPoint = null, $baseEntityType = null, $entityId = null, $isDefault = null, $name = null, $sql = null, $sortingColumn = null)
    {
        $this
            ->setId($id)
            ->setViewEntryPoint($viewEntryPoint)
            ->setBaseEntityType($baseEntityType)
            ->setEntityId($entityId)
            ->setIsDefault($isDefault)
            ->setName($name)
            ->setSql($sql)
            ->setSortingColumn($sortingColumn);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvViewDefinitionData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ViewEntryPoint value
     * @return string
     */
    public function getViewEntryPoint()
    {
        return $this->ViewEntryPoint;
    }
    /**
     * Set ViewEntryPoint value
     * @uses \EnumType\ViewEntryPoint::valueIsValid()
     * @uses \EnumType\ViewEntryPoint::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viewEntryPoint
     * @return \StructType\PvViewDefinitionData
     */
    public function setViewEntryPoint($viewEntryPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ViewEntryPoint::valueIsValid($viewEntryPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ViewEntryPoint', is_array($viewEntryPoint) ? implode(', ', $viewEntryPoint) : var_export($viewEntryPoint, true), implode(', ', \EnumType\ViewEntryPoint::getValidValues())), __LINE__);
        }
        $this->ViewEntryPoint = $viewEntryPoint;
        return $this;
    }
    /**
     * Get BaseEntityType value
     * @return string
     */
    public function getBaseEntityType()
    {
        return $this->BaseEntityType;
    }
    /**
     * Set BaseEntityType value
     * @uses \EnumType\BaseEntityType::valueIsValid()
     * @uses \EnumType\BaseEntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseEntityType
     * @return \StructType\PvViewDefinitionData
     */
    public function setBaseEntityType($baseEntityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BaseEntityType::valueIsValid($baseEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BaseEntityType', is_array($baseEntityType) ? implode(', ', $baseEntityType) : var_export($baseEntityType, true), implode(', ', \EnumType\BaseEntityType::getValidValues())), __LINE__);
        }
        $this->BaseEntityType = $baseEntityType;
        return $this;
    }
    /**
     * Get EntityId value
     * @return string
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param string $entityId
     * @return \StructType\PvViewDefinitionData
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\PvViewDefinitionData
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PvViewDefinitionData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Sql value
     * @return string|null
     */
    public function getSql()
    {
        return $this->Sql;
    }
    /**
     * Set Sql value
     * @param string $sql
     * @return \StructType\PvViewDefinitionData
     */
    public function setSql($sql = null)
    {
        // validation for constraint: string
        if (!is_null($sql) && !is_string($sql)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sql, true), gettype($sql)), __LINE__);
        }
        $this->Sql = $sql;
        return $this;
    }
    /**
     * Get SortingColumn value
     * @return string|null
     */
    public function getSortingColumn()
    {
        return $this->SortingColumn;
    }
    /**
     * Set SortingColumn value
     * @param string $sortingColumn
     * @return \StructType\PvViewDefinitionData
     */
    public function setSortingColumn($sortingColumn = null)
    {
        // validation for constraint: string
        if (!is_null($sortingColumn) && !is_string($sortingColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortingColumn, true), gettype($sortingColumn)), __LINE__);
        }
        $this->SortingColumn = $sortingColumn;
        return $this;
    }
}
