<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvUserData StructType
 * @subpackage Structs
 */
class PvUserData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $RelationshipId;
    /**
     * The RelationId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $RelationId;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The SortingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortingName;
    /**
     * The Initials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Initials;
    /**
     * The Base64EncodedImage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Base64EncodedImage;
    /**
     * Constructor method for PvUserData
     * @uses PvUserData::setId()
     * @uses PvUserData::setRelationshipId()
     * @uses PvUserData::setRelationId()
     * @uses PvUserData::setDisplayName()
     * @uses PvUserData::setSortingName()
     * @uses PvUserData::setInitials()
     * @uses PvUserData::setBase64EncodedImage()
     * @param string $id
     * @param string $relationshipId
     * @param string $relationId
     * @param string $displayName
     * @param string $sortingName
     * @param string $initials
     * @param string $base64EncodedImage
     */
    public function __construct($id = null, $relationshipId = null, $relationId = null, $displayName = null, $sortingName = null, $initials = null, $base64EncodedImage = null)
    {
        $this
            ->setId($id)
            ->setRelationshipId($relationshipId)
            ->setRelationId($relationId)
            ->setDisplayName($displayName)
            ->setSortingName($sortingName)
            ->setInitials($initials)
            ->setBase64EncodedImage($base64EncodedImage);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvUserData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RelationshipId value
     * @return string
     */
    public function getRelationshipId()
    {
        return $this->RelationshipId;
    }
    /**
     * Set RelationshipId value
     * @param string $relationshipId
     * @return \StructType\PvUserData
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        $this->RelationshipId = $relationshipId;
        return $this;
    }
    /**
     * Get RelationId value
     * @return string
     */
    public function getRelationId()
    {
        return $this->RelationId;
    }
    /**
     * Set RelationId value
     * @param string $relationId
     * @return \StructType\PvUserData
     */
    public function setRelationId($relationId = null)
    {
        // validation for constraint: string
        if (!is_null($relationId) && !is_string($relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationId, true), gettype($relationId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationId, true)), __LINE__);
        }
        $this->RelationId = $relationId;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PvUserData
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get SortingName value
     * @return string|null
     */
    public function getSortingName()
    {
        return $this->SortingName;
    }
    /**
     * Set SortingName value
     * @param string $sortingName
     * @return \StructType\PvUserData
     */
    public function setSortingName($sortingName = null)
    {
        // validation for constraint: string
        if (!is_null($sortingName) && !is_string($sortingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortingName, true), gettype($sortingName)), __LINE__);
        }
        $this->SortingName = $sortingName;
        return $this;
    }
    /**
     * Get Initials value
     * @return string|null
     */
    public function getInitials()
    {
        return $this->Initials;
    }
    /**
     * Set Initials value
     * @param string $initials
     * @return \StructType\PvUserData
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        $this->Initials = $initials;
        return $this;
    }
    /**
     * Get Base64EncodedImage value
     * @return string|null
     */
    public function getBase64EncodedImage()
    {
        return $this->Base64EncodedImage;
    }
    /**
     * Set Base64EncodedImage value
     * @param string $base64EncodedImage
     * @return \StructType\PvUserData
     */
    public function setBase64EncodedImage($base64EncodedImage = null)
    {
        // validation for constraint: string
        if (!is_null($base64EncodedImage) && !is_string($base64EncodedImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64EncodedImage, true), gettype($base64EncodedImage)), __LINE__);
        }
        $this->Base64EncodedImage = $base64EncodedImage;
        return $this;
    }
}
