<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvTranslationData StructType
 * @subpackage Structs
 */
class PvTranslationData extends AbstractStructBase
{
    /**
     * The ResourceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResourceCode;
    /**
     * The CultureCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureCode;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for PvTranslationData
     * @uses PvTranslationData::setResourceCode()
     * @uses PvTranslationData::setCultureCode()
     * @uses PvTranslationData::setValue()
     * @param string $resourceCode
     * @param string $cultureCode
     * @param string $value
     */
    public function __construct($resourceCode = null, $cultureCode = null, $value = null)
    {
        $this
            ->setResourceCode($resourceCode)
            ->setCultureCode($cultureCode)
            ->setValue($value);
    }
    /**
     * Get ResourceCode value
     * @return string|null
     */
    public function getResourceCode()
    {
        return $this->ResourceCode;
    }
    /**
     * Set ResourceCode value
     * @param string $resourceCode
     * @return \StructType\PvTranslationData
     */
    public function setResourceCode($resourceCode = null)
    {
        // validation for constraint: string
        if (!is_null($resourceCode) && !is_string($resourceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resourceCode, true), gettype($resourceCode)), __LINE__);
        }
        $this->ResourceCode = $resourceCode;
        return $this;
    }
    /**
     * Get CultureCode value
     * @return string|null
     */
    public function getCultureCode()
    {
        return $this->CultureCode;
    }
    /**
     * Set CultureCode value
     * @param string $cultureCode
     * @return \StructType\PvTranslationData
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureCode, true), gettype($cultureCode)), __LINE__);
        }
        $this->CultureCode = $cultureCode;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\PvTranslationData
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
