<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvRelationshipMarkDataCompact StructType
 * @subpackage Structs
 */
class PvRelationshipMarkDataCompact extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The MarkId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MarkId;
    /**
     * The PreferredAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PreferredAddress;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * Constructor method for PvRelationshipMarkDataCompact
     * @uses PvRelationshipMarkDataCompact::setId()
     * @uses PvRelationshipMarkDataCompact::setMarkId()
     * @uses PvRelationshipMarkDataCompact::setPreferredAddress()
     * @uses PvRelationshipMarkDataCompact::setDate()
     * @param string $id
     * @param string $markId
     * @param string $preferredAddress
     * @param string $date
     */
    public function __construct($id = null, $markId = null, $preferredAddress = null, $date = null)
    {
        $this
            ->setId($id)
            ->setMarkId($markId)
            ->setPreferredAddress($preferredAddress)
            ->setDate($date);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvRelationshipMarkDataCompact
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MarkId value
     * @return string
     */
    public function getMarkId()
    {
        return $this->MarkId;
    }
    /**
     * Set MarkId value
     * @param string $markId
     * @return \StructType\PvRelationshipMarkDataCompact
     */
    public function setMarkId($markId = null)
    {
        // validation for constraint: string
        if (!is_null($markId) && !is_string($markId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markId, true), gettype($markId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($markId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $markId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($markId, true)), __LINE__);
        }
        $this->MarkId = $markId;
        return $this;
    }
    /**
     * Get PreferredAddress value
     * @return string
     */
    public function getPreferredAddress()
    {
        return $this->PreferredAddress;
    }
    /**
     * Set PreferredAddress value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferredAddress
     * @return \StructType\PvRelationshipMarkDataCompact
     */
    public function setPreferredAddress($preferredAddress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($preferredAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AddressType', is_array($preferredAddress) ? implode(', ', $preferredAddress) : var_export($preferredAddress, true), implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->PreferredAddress = $preferredAddress;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\PvRelationshipMarkDataCompact
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
}
