<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvNotificationData StructType
 * @subpackage Structs
 */
class PvNotificationData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The ActivityLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ActivityLocation;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivityData
     */
    public $Activity;
    /**
     * Constructor method for PvNotificationData
     * @uses PvNotificationData::setId()
     * @uses PvNotificationData::setActivityLocation()
     * @uses PvNotificationData::setActivity()
     * @param string $id
     * @param string $activityLocation
     * @param \StructType\PvActivityData $activity
     */
    public function __construct($id = null, $activityLocation = null, \StructType\PvActivityData $activity = null)
    {
        $this
            ->setId($id)
            ->setActivityLocation($activityLocation)
            ->setActivity($activity);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvNotificationData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ActivityLocation value
     * @return string
     */
    public function getActivityLocation()
    {
        return $this->ActivityLocation;
    }
    /**
     * Set ActivityLocation value
     * @uses \EnumType\ActivityLocation::valueIsValid()
     * @uses \EnumType\ActivityLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityLocation
     * @return \StructType\PvNotificationData
     */
    public function setActivityLocation($activityLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityLocation::valueIsValid($activityLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActivityLocation', is_array($activityLocation) ? implode(', ', $activityLocation) : var_export($activityLocation, true), implode(', ', \EnumType\ActivityLocation::getValidValues())), __LINE__);
        }
        $this->ActivityLocation = $activityLocation;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\PvActivityData|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\PvActivityData $activity
     * @return \StructType\PvNotificationData
     */
    public function setActivity(\StructType\PvActivityData $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
}
