<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvMenuItemData StructType
 * @subpackage Structs
 */
class PvMenuItemData extends AbstractStructBase
{
    /**
     * The CreateMenuItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateMenuItemType;
    /**
     * The EntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityTypeId;
    /**
     * The WorkflowId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $WorkflowId;
    /**
     * The WorkflowStepId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $WorkflowStepId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for PvMenuItemData
     * @uses PvMenuItemData::setCreateMenuItemType()
     * @uses PvMenuItemData::setEntityTypeId()
     * @uses PvMenuItemData::setWorkflowId()
     * @uses PvMenuItemData::setWorkflowStepId()
     * @uses PvMenuItemData::setName()
     * @param string $createMenuItemType
     * @param string $entityTypeId
     * @param string $workflowId
     * @param string $workflowStepId
     * @param string $name
     */
    public function __construct($createMenuItemType = null, $entityTypeId = null, $workflowId = null, $workflowStepId = null, $name = null)
    {
        $this
            ->setCreateMenuItemType($createMenuItemType)
            ->setEntityTypeId($entityTypeId)
            ->setWorkflowId($workflowId)
            ->setWorkflowStepId($workflowStepId)
            ->setName($name);
    }
    /**
     * Get CreateMenuItemType value
     * @return string
     */
    public function getCreateMenuItemType()
    {
        return $this->CreateMenuItemType;
    }
    /**
     * Set CreateMenuItemType value
     * @uses \EnumType\CreateMenuItemType::valueIsValid()
     * @uses \EnumType\CreateMenuItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $createMenuItemType
     * @return \StructType\PvMenuItemData
     */
    public function setCreateMenuItemType($createMenuItemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreateMenuItemType::valueIsValid($createMenuItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreateMenuItemType', is_array($createMenuItemType) ? implode(', ', $createMenuItemType) : var_export($createMenuItemType, true), implode(', ', \EnumType\CreateMenuItemType::getValidValues())), __LINE__);
        }
        $this->CreateMenuItemType = $createMenuItemType;
        return $this;
    }
    /**
     * Get EntityTypeId value
     * @return string
     */
    public function getEntityTypeId()
    {
        return $this->EntityTypeId;
    }
    /**
     * Set EntityTypeId value
     * @param string $entityTypeId
     * @return \StructType\PvMenuItemData
     */
    public function setEntityTypeId($entityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($entityTypeId) && !is_string($entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTypeId, true), gettype($entityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityTypeId, true)), __LINE__);
        }
        $this->EntityTypeId = $entityTypeId;
        return $this;
    }
    /**
     * Get WorkflowId value
     * @return string
     */
    public function getWorkflowId()
    {
        return $this->WorkflowId;
    }
    /**
     * Set WorkflowId value
     * @param string $workflowId
     * @return \StructType\PvMenuItemData
     */
    public function setWorkflowId($workflowId = null)
    {
        // validation for constraint: string
        if (!is_null($workflowId) && !is_string($workflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workflowId, true), gettype($workflowId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($workflowId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $workflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($workflowId, true)), __LINE__);
        }
        $this->WorkflowId = $workflowId;
        return $this;
    }
    /**
     * Get WorkflowStepId value
     * @return string
     */
    public function getWorkflowStepId()
    {
        return $this->WorkflowStepId;
    }
    /**
     * Set WorkflowStepId value
     * @param string $workflowStepId
     * @return \StructType\PvMenuItemData
     */
    public function setWorkflowStepId($workflowStepId = null)
    {
        // validation for constraint: string
        if (!is_null($workflowStepId) && !is_string($workflowStepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workflowStepId, true), gettype($workflowStepId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($workflowStepId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $workflowStepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($workflowStepId, true)), __LINE__);
        }
        $this->WorkflowStepId = $workflowStepId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PvMenuItemData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
