<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvLineData StructType
 * @subpackage Structs
 */
class PvLineData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The FieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvFieldValuesData
     */
    public $FieldValues;
    /**
     * Constructor method for PvLineData
     * @uses PvLineData::setId()
     * @uses PvLineData::setFieldValues()
     * @param string $id
     * @param \StructType\PvFieldValuesData $fieldValues
     */
    public function __construct($id = null, \StructType\PvFieldValuesData $fieldValues = null)
    {
        $this
            ->setId($id)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvLineData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get FieldValues value
     * @return \StructType\PvFieldValuesData|null
     */
    public function getFieldValues()
    {
        return $this->FieldValues;
    }
    /**
     * Set FieldValues value
     * @param \StructType\PvFieldValuesData $fieldValues
     * @return \StructType\PvLineData
     */
    public function setFieldValues(\StructType\PvFieldValuesData $fieldValues = null)
    {
        $this->FieldValues = $fieldValues;
        return $this;
    }
}
