<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvLanguageData StructType
 * @subpackage Structs
 */
class PvLanguageData extends AbstractStructBase
{
    /**
     * The CultureCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Base64EncodedFlagFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Base64EncodedFlagFile;
    /**
     * Constructor method for PvLanguageData
     * @uses PvLanguageData::setCultureCode()
     * @uses PvLanguageData::setName()
     * @uses PvLanguageData::setBase64EncodedFlagFile()
     * @param string $cultureCode
     * @param string $name
     * @param string $base64EncodedFlagFile
     */
    public function __construct($cultureCode = null, $name = null, $base64EncodedFlagFile = null)
    {
        $this
            ->setCultureCode($cultureCode)
            ->setName($name)
            ->setBase64EncodedFlagFile($base64EncodedFlagFile);
    }
    /**
     * Get CultureCode value
     * @return string|null
     */
    public function getCultureCode()
    {
        return $this->CultureCode;
    }
    /**
     * Set CultureCode value
     * @param string $cultureCode
     * @return \StructType\PvLanguageData
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureCode, true), gettype($cultureCode)), __LINE__);
        }
        $this->CultureCode = $cultureCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PvLanguageData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Base64EncodedFlagFile value
     * @return string|null
     */
    public function getBase64EncodedFlagFile()
    {
        return $this->Base64EncodedFlagFile;
    }
    /**
     * Set Base64EncodedFlagFile value
     * @param string $base64EncodedFlagFile
     * @return \StructType\PvLanguageData
     */
    public function setBase64EncodedFlagFile($base64EncodedFlagFile = null)
    {
        // validation for constraint: string
        if (!is_null($base64EncodedFlagFile) && !is_string($base64EncodedFlagFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64EncodedFlagFile, true), gettype($base64EncodedFlagFile)), __LINE__);
        }
        $this->Base64EncodedFlagFile = $base64EncodedFlagFile;
        return $this;
    }
}
