<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvEntityTypeData StructType
 * @subpackage Structs
 */
class PvEntityTypeData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityId;
    /**
     * The BaseEntityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaseEntityType;
    /**
     * The BaseRelationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaseRelationType;
    /**
     * The DescriptionSingular
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionSingular;
    /**
     * The DescriptionPlural
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionPlural;
    /**
     * Constructor method for PvEntityTypeData
     * @uses PvEntityTypeData::setId()
     * @uses PvEntityTypeData::setEntityId()
     * @uses PvEntityTypeData::setBaseEntityType()
     * @uses PvEntityTypeData::setBaseRelationType()
     * @uses PvEntityTypeData::setDescriptionSingular()
     * @uses PvEntityTypeData::setDescriptionPlural()
     * @param string $id
     * @param string $entityId
     * @param string $baseEntityType
     * @param string $baseRelationType
     * @param string $descriptionSingular
     * @param string $descriptionPlural
     */
    public function __construct($id = null, $entityId = null, $baseEntityType = null, $baseRelationType = null, $descriptionSingular = null, $descriptionPlural = null)
    {
        $this
            ->setId($id)
            ->setEntityId($entityId)
            ->setBaseEntityType($baseEntityType)
            ->setBaseRelationType($baseRelationType)
            ->setDescriptionSingular($descriptionSingular)
            ->setDescriptionPlural($descriptionPlural);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvEntityTypeData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get EntityId value
     * @return string
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param string $entityId
     * @return \StructType\PvEntityTypeData
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get BaseEntityType value
     * @return string
     */
    public function getBaseEntityType()
    {
        return $this->BaseEntityType;
    }
    /**
     * Set BaseEntityType value
     * @uses \EnumType\BaseEntityType::valueIsValid()
     * @uses \EnumType\BaseEntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseEntityType
     * @return \StructType\PvEntityTypeData
     */
    public function setBaseEntityType($baseEntityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BaseEntityType::valueIsValid($baseEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BaseEntityType', is_array($baseEntityType) ? implode(', ', $baseEntityType) : var_export($baseEntityType, true), implode(', ', \EnumType\BaseEntityType::getValidValues())), __LINE__);
        }
        $this->BaseEntityType = $baseEntityType;
        return $this;
    }
    /**
     * Get BaseRelationType value
     * @return string
     */
    public function getBaseRelationType()
    {
        return $this->BaseRelationType;
    }
    /**
     * Set BaseRelationType value
     * @uses \EnumType\BaseRelationType::valueIsValid()
     * @uses \EnumType\BaseRelationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseRelationType
     * @return \StructType\PvEntityTypeData
     */
    public function setBaseRelationType($baseRelationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BaseRelationType::valueIsValid($baseRelationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BaseRelationType', is_array($baseRelationType) ? implode(', ', $baseRelationType) : var_export($baseRelationType, true), implode(', ', \EnumType\BaseRelationType::getValidValues())), __LINE__);
        }
        $this->BaseRelationType = $baseRelationType;
        return $this;
    }
    /**
     * Get DescriptionSingular value
     * @return string|null
     */
    public function getDescriptionSingular()
    {
        return $this->DescriptionSingular;
    }
    /**
     * Set DescriptionSingular value
     * @param string $descriptionSingular
     * @return \StructType\PvEntityTypeData
     */
    public function setDescriptionSingular($descriptionSingular = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionSingular) && !is_string($descriptionSingular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionSingular, true), gettype($descriptionSingular)), __LINE__);
        }
        $this->DescriptionSingular = $descriptionSingular;
        return $this;
    }
    /**
     * Get DescriptionPlural value
     * @return string|null
     */
    public function getDescriptionPlural()
    {
        return $this->DescriptionPlural;
    }
    /**
     * Set DescriptionPlural value
     * @param string $descriptionPlural
     * @return \StructType\PvEntityTypeData
     */
    public function setDescriptionPlural($descriptionPlural = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionPlural) && !is_string($descriptionPlural)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionPlural, true), gettype($descriptionPlural)), __LINE__);
        }
        $this->DescriptionPlural = $descriptionPlural;
        return $this;
    }
}
