<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvApiResultDataOfObject StructType
 * @subpackage Structs
 */
class PvApiResultDataOfObject extends AbstractStructBase
{
    /**
     * The Succeeded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Succeeded;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Number;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for PvApiResultDataOfObject
     * @uses PvApiResultDataOfObject::setSucceeded()
     * @uses PvApiResultDataOfObject::setNumber()
     * @uses PvApiResultDataOfObject::setCode()
     * @uses PvApiResultDataOfObject::setDescription()
     * @param bool $succeeded
     * @param int $number
     * @param string $code
     * @param string $description
     */
    public function __construct($succeeded = null, $number = null, $code = null, $description = null)
    {
        $this
            ->setSucceeded($succeeded)
            ->setNumber($number)
            ->setCode($code)
            ->setDescription($description);
    }
    /**
     * Get Succeeded value
     * @return bool
     */
    public function getSucceeded()
    {
        return $this->Succeeded;
    }
    /**
     * Set Succeeded value
     * @param bool $succeeded
     * @return \StructType\PvApiResultDataOfObject
     */
    public function setSucceeded($succeeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($succeeded) && !is_bool($succeeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($succeeded, true), gettype($succeeded)), __LINE__);
        }
        $this->Succeeded = $succeeded;
        return $this;
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\PvApiResultDataOfObject
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\PvApiResultDataOfObject
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PvApiResultDataOfObject
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
