<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvActivityFollowUpData StructType
 * @subpackage Structs
 */
class PvActivityFollowUpData extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $End;
    /**
     * The InAgenda
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InAgenda;
    /**
     * The ReminderPeriodInMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReminderPeriodInMinutes;
    /**
     * The OwnerUserId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $OwnerUserId;
    /**
     * The PlacedInQueueId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $PlacedInQueueId;
    /**
     * Constructor method for PvActivityFollowUpData
     * @uses PvActivityFollowUpData::setStart()
     * @uses PvActivityFollowUpData::setEnd()
     * @uses PvActivityFollowUpData::setInAgenda()
     * @uses PvActivityFollowUpData::setReminderPeriodInMinutes()
     * @uses PvActivityFollowUpData::setOwnerUserId()
     * @uses PvActivityFollowUpData::setPlacedInQueueId()
     * @param string $start
     * @param string $end
     * @param bool $inAgenda
     * @param int $reminderPeriodInMinutes
     * @param string $ownerUserId
     * @param string $placedInQueueId
     */
    public function __construct($start = null, $end = null, $inAgenda = null, $reminderPeriodInMinutes = null, $ownerUserId = null, $placedInQueueId = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setInAgenda($inAgenda)
            ->setReminderPeriodInMinutes($reminderPeriodInMinutes)
            ->setOwnerUserId($ownerUserId)
            ->setPlacedInQueueId($placedInQueueId);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\PvActivityFollowUpData
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\PvActivityFollowUpData
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get InAgenda value
     * @return bool
     */
    public function getInAgenda()
    {
        return $this->InAgenda;
    }
    /**
     * Set InAgenda value
     * @param bool $inAgenda
     * @return \StructType\PvActivityFollowUpData
     */
    public function setInAgenda($inAgenda = null)
    {
        // validation for constraint: boolean
        if (!is_null($inAgenda) && !is_bool($inAgenda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inAgenda, true), gettype($inAgenda)), __LINE__);
        }
        $this->InAgenda = $inAgenda;
        return $this;
    }
    /**
     * Get ReminderPeriodInMinutes value
     * @return int
     */
    public function getReminderPeriodInMinutes()
    {
        return $this->ReminderPeriodInMinutes;
    }
    /**
     * Set ReminderPeriodInMinutes value
     * @param int $reminderPeriodInMinutes
     * @return \StructType\PvActivityFollowUpData
     */
    public function setReminderPeriodInMinutes($reminderPeriodInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($reminderPeriodInMinutes) && !(is_int($reminderPeriodInMinutes) || ctype_digit($reminderPeriodInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reminderPeriodInMinutes, true), gettype($reminderPeriodInMinutes)), __LINE__);
        }
        $this->ReminderPeriodInMinutes = $reminderPeriodInMinutes;
        return $this;
    }
    /**
     * Get OwnerUserId value
     * @return string
     */
    public function getOwnerUserId()
    {
        return $this->OwnerUserId;
    }
    /**
     * Set OwnerUserId value
     * @param string $ownerUserId
     * @return \StructType\PvActivityFollowUpData
     */
    public function setOwnerUserId($ownerUserId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerUserId) && !is_string($ownerUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerUserId, true), gettype($ownerUserId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($ownerUserId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $ownerUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($ownerUserId, true)), __LINE__);
        }
        $this->OwnerUserId = $ownerUserId;
        return $this;
    }
    /**
     * Get PlacedInQueueId value
     * @return string
     */
    public function getPlacedInQueueId()
    {
        return $this->PlacedInQueueId;
    }
    /**
     * Set PlacedInQueueId value
     * @param string $placedInQueueId
     * @return \StructType\PvActivityFollowUpData
     */
    public function setPlacedInQueueId($placedInQueueId = null)
    {
        // validation for constraint: string
        if (!is_null($placedInQueueId) && !is_string($placedInQueueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placedInQueueId, true), gettype($placedInQueueId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($placedInQueueId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $placedInQueueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($placedInQueueId, true)), __LINE__);
        }
        $this->PlacedInQueueId = $placedInQueueId;
        return $this;
    }
}
