<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PvActivityData StructType
 * @subpackage Structs
 */
class PvActivityData extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Id;
    /**
     * The ViewSortingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ViewSortingDate;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The FollowUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivityFollowUpData
     */
    public $FollowUp;
    /**
     * The Settings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivitySettingsData
     */
    public $Settings;
    /**
     * The ParentRelationship
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvRelationshipData
     */
    public $ParentRelationship;
    /**
     * The ChildRelationship
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvRelationshipData
     */
    public $ChildRelationship;
    /**
     * The FieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvFieldValuesData
     */
    public $FieldValues;
    /**
     * The AuditData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvAuditData
     */
    public $AuditData;
    /**
     * The ActivityAuditData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivityAuditData
     */
    public $ActivityAuditData;
    /**
     * The CounterValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvCounterData
     */
    public $CounterValues;
    /**
     * Constructor method for PvActivityData
     * @uses PvActivityData::setId()
     * @uses PvActivityData::setViewSortingDate()
     * @uses PvActivityData::setInfo()
     * @uses PvActivityData::setNumber()
     * @uses PvActivityData::setFollowUp()
     * @uses PvActivityData::setSettings()
     * @uses PvActivityData::setParentRelationship()
     * @uses PvActivityData::setChildRelationship()
     * @uses PvActivityData::setFieldValues()
     * @uses PvActivityData::setAuditData()
     * @uses PvActivityData::setActivityAuditData()
     * @uses PvActivityData::setCounterValues()
     * @param string $id
     * @param string $viewSortingDate
     * @param string $info
     * @param string $number
     * @param \StructType\PvActivityFollowUpData $followUp
     * @param \StructType\PvActivitySettingsData $settings
     * @param \StructType\PvRelationshipData $parentRelationship
     * @param \StructType\PvRelationshipData $childRelationship
     * @param \StructType\PvFieldValuesData $fieldValues
     * @param \StructType\PvAuditData $auditData
     * @param \StructType\PvActivityAuditData $activityAuditData
     * @param \ArrayType\ArrayOfPvCounterData $counterValues
     */
    public function __construct($id = null, $viewSortingDate = null, $info = null, $number = null, \StructType\PvActivityFollowUpData $followUp = null, \StructType\PvActivitySettingsData $settings = null, \StructType\PvRelationshipData $parentRelationship = null, \StructType\PvRelationshipData $childRelationship = null, \StructType\PvFieldValuesData $fieldValues = null, \StructType\PvAuditData $auditData = null, \StructType\PvActivityAuditData $activityAuditData = null, \ArrayType\ArrayOfPvCounterData $counterValues = null)
    {
        $this
            ->setId($id)
            ->setViewSortingDate($viewSortingDate)
            ->setInfo($info)
            ->setNumber($number)
            ->setFollowUp($followUp)
            ->setSettings($settings)
            ->setParentRelationship($parentRelationship)
            ->setChildRelationship($childRelationship)
            ->setFieldValues($fieldValues)
            ->setAuditData($auditData)
            ->setActivityAuditData($activityAuditData)
            ->setCounterValues($counterValues);
    }
    /**
     * Get Id value
     * @return string
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\PvActivityData
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($id) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ViewSortingDate value
     * @return string
     */
    public function getViewSortingDate()
    {
        return $this->ViewSortingDate;
    }
    /**
     * Set ViewSortingDate value
     * @param string $viewSortingDate
     * @return \StructType\PvActivityData
     */
    public function setViewSortingDate($viewSortingDate = null)
    {
        // validation for constraint: string
        if (!is_null($viewSortingDate) && !is_string($viewSortingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewSortingDate, true), gettype($viewSortingDate)), __LINE__);
        }
        $this->ViewSortingDate = $viewSortingDate;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\PvActivityData
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\PvActivityData
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get FollowUp value
     * @return \StructType\PvActivityFollowUpData|null
     */
    public function getFollowUp()
    {
        return $this->FollowUp;
    }
    /**
     * Set FollowUp value
     * @param \StructType\PvActivityFollowUpData $followUp
     * @return \StructType\PvActivityData
     */
    public function setFollowUp(\StructType\PvActivityFollowUpData $followUp = null)
    {
        $this->FollowUp = $followUp;
        return $this;
    }
    /**
     * Get Settings value
     * @return \StructType\PvActivitySettingsData|null
     */
    public function getSettings()
    {
        return $this->Settings;
    }
    /**
     * Set Settings value
     * @param \StructType\PvActivitySettingsData $settings
     * @return \StructType\PvActivityData
     */
    public function setSettings(\StructType\PvActivitySettingsData $settings = null)
    {
        $this->Settings = $settings;
        return $this;
    }
    /**
     * Get ParentRelationship value
     * @return \StructType\PvRelationshipData|null
     */
    public function getParentRelationship()
    {
        return $this->ParentRelationship;
    }
    /**
     * Set ParentRelationship value
     * @param \StructType\PvRelationshipData $parentRelationship
     * @return \StructType\PvActivityData
     */
    public function setParentRelationship(\StructType\PvRelationshipData $parentRelationship = null)
    {
        $this->ParentRelationship = $parentRelationship;
        return $this;
    }
    /**
     * Get ChildRelationship value
     * @return \StructType\PvRelationshipData|null
     */
    public function getChildRelationship()
    {
        return $this->ChildRelationship;
    }
    /**
     * Set ChildRelationship value
     * @param \StructType\PvRelationshipData $childRelationship
     * @return \StructType\PvActivityData
     */
    public function setChildRelationship(\StructType\PvRelationshipData $childRelationship = null)
    {
        $this->ChildRelationship = $childRelationship;
        return $this;
    }
    /**
     * Get FieldValues value
     * @return \StructType\PvFieldValuesData|null
     */
    public function getFieldValues()
    {
        return $this->FieldValues;
    }
    /**
     * Set FieldValues value
     * @param \StructType\PvFieldValuesData $fieldValues
     * @return \StructType\PvActivityData
     */
    public function setFieldValues(\StructType\PvFieldValuesData $fieldValues = null)
    {
        $this->FieldValues = $fieldValues;
        return $this;
    }
    /**
     * Get AuditData value
     * @return \StructType\PvAuditData|null
     */
    public function getAuditData()
    {
        return $this->AuditData;
    }
    /**
     * Set AuditData value
     * @param \StructType\PvAuditData $auditData
     * @return \StructType\PvActivityData
     */
    public function setAuditData(\StructType\PvAuditData $auditData = null)
    {
        $this->AuditData = $auditData;
        return $this;
    }
    /**
     * Get ActivityAuditData value
     * @return \StructType\PvActivityAuditData|null
     */
    public function getActivityAuditData()
    {
        return $this->ActivityAuditData;
    }
    /**
     * Set ActivityAuditData value
     * @param \StructType\PvActivityAuditData $activityAuditData
     * @return \StructType\PvActivityData
     */
    public function setActivityAuditData(\StructType\PvActivityAuditData $activityAuditData = null)
    {
        $this->ActivityAuditData = $activityAuditData;
        return $this;
    }
    /**
     * Get CounterValues value
     * @return \ArrayType\ArrayOfPvCounterData|null
     */
    public function getCounterValues()
    {
        return $this->CounterValues;
    }
    /**
     * Set CounterValues value
     * @param \ArrayType\ArrayOfPvCounterData $counterValues
     * @return \StructType\PvActivityData
     */
    public function setCounterValues(\ArrayType\ArrayOfPvCounterData $counterValues = null)
    {
        $this->CounterValues = $counterValues;
        return $this;
    }
}
