<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSearchByFieldExact StructType
 * @subpackage Structs
 */
class ProductSearchByFieldExact extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The fieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $fieldValues;
    /**
     * Constructor method for ProductSearchByFieldExact
     * @uses ProductSearchByFieldExact::setCredentials()
     * @uses ProductSearchByFieldExact::setFieldValues()
     * @param \StructType\ApiCredentials $credentials
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     */
    public function __construct(\StructType\ApiCredentials $credentials = null, \ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this
            ->setCredentials($credentials)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ProductSearchByFieldExact
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get fieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getFieldValues()
    {
        return $this->fieldValues;
    }
    /**
     * Set fieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @return \StructType\ProductSearchByFieldExact
     */
    public function setFieldValues(\ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this->fieldValues = $fieldValues;
        return $this;
    }
}
