<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductGroupUpdate StructType
 * @subpackage Structs
 */
class ProductGroupUpdate extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The productGroupData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvProductGroupData
     */
    public $productGroupData;
    /**
     * Constructor method for ProductGroupUpdate
     * @uses ProductGroupUpdate::setCredentials()
     * @uses ProductGroupUpdate::setProductGroupData()
     * @param \StructType\ApiCredentials $credentials
     * @param \StructType\PvProductGroupData $productGroupData
     */
    public function __construct(\StructType\ApiCredentials $credentials = null, \StructType\PvProductGroupData $productGroupData = null)
    {
        $this
            ->setCredentials($credentials)
            ->setProductGroupData($productGroupData);
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ProductGroupUpdate
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get productGroupData value
     * @return \StructType\PvProductGroupData|null
     */
    public function getProductGroupData()
    {
        return $this->productGroupData;
    }
    /**
     * Set productGroupData value
     * @param \StructType\PvProductGroupData $productGroupData
     * @return \StructType\ProductGroupUpdate
     */
    public function setProductGroupData(\StructType\PvProductGroupData $productGroupData = null)
    {
        $this->productGroupData = $productGroupData;
        return $this;
    }
}
