<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductGroupGet StructType
 * @subpackage Structs
 */
class ProductGroupGet extends AbstractStructBase
{
    /**
     * The productGroupId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $productGroupId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for ProductGroupGet
     * @uses ProductGroupGet::setProductGroupId()
     * @uses ProductGroupGet::setCredentials()
     * @param string $productGroupId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($productGroupId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setProductGroupId($productGroupId)
            ->setCredentials($credentials);
    }
    /**
     * Get productGroupId value
     * @return string
     */
    public function getProductGroupId()
    {
        return $this->productGroupId;
    }
    /**
     * Set productGroupId value
     * @param string $productGroupId
     * @return \StructType\ProductGroupGet
     */
    public function setProductGroupId($productGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($productGroupId) && !is_string($productGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGroupId, true), gettype($productGroupId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($productGroupId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $productGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($productGroupId, true)), __LINE__);
        }
        $this->productGroupId = $productGroupId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ProductGroupGet
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
