<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterGet StructType
 * @subpackage Structs
 */
class ParameterGet extends AbstractStructBase
{
    /**
     * The apiParameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $apiParameter;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for ParameterGet
     * @uses ParameterGet::setApiParameter()
     * @uses ParameterGet::setCredentials()
     * @param string $apiParameter
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($apiParameter = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setApiParameter($apiParameter)
            ->setCredentials($credentials);
    }
    /**
     * Get apiParameter value
     * @return string
     */
    public function getApiParameter()
    {
        return $this->apiParameter;
    }
    /**
     * Set apiParameter value
     * @uses \EnumType\ApiParameters::valueIsValid()
     * @uses \EnumType\ApiParameters::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $apiParameter
     * @return \StructType\ParameterGet
     */
    public function setApiParameter($apiParameter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ApiParameters::valueIsValid($apiParameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ApiParameters', is_array($apiParameter) ? implode(', ', $apiParameter) : var_export($apiParameter, true), implode(', ', \EnumType\ApiParameters::getValidValues())), __LINE__);
        }
        $this->apiParameter = $apiParameter;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ParameterGet
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
