<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationGetCountResult StructType
 * @subpackage Structs
 */
class NotificationGetCountResult extends PvApiResult
{
    /**
     * The NumberOfNotifications
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfNotifications;
    /**
     * Constructor method for NotificationGetCountResult
     * @uses NotificationGetCountResult::setNumberOfNotifications()
     * @param int $numberOfNotifications
     */
    public function __construct($numberOfNotifications = null)
    {
        $this
            ->setNumberOfNotifications($numberOfNotifications);
    }
    /**
     * Get NumberOfNotifications value
     * @return int
     */
    public function getNumberOfNotifications()
    {
        return $this->NumberOfNotifications;
    }
    /**
     * Set NumberOfNotifications value
     * @param int $numberOfNotifications
     * @return \StructType\NotificationGetCountResult
     */
    public function setNumberOfNotifications($numberOfNotifications = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfNotifications) && !(is_int($numberOfNotifications) || ctype_digit($numberOfNotifications))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfNotifications, true), gettype($numberOfNotifications)), __LINE__);
        }
        $this->NumberOfNotifications = $numberOfNotifications;
        return $this;
    }
}
