<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileRemoveDeviceId StructType
 * @subpackage Structs
 */
class MobileRemoveDeviceId extends AbstractStructBase
{
    /**
     * The deviceOs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $deviceOs;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The deviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceId;
    /**
     * Constructor method for MobileRemoveDeviceId
     * @uses MobileRemoveDeviceId::setDeviceOs()
     * @uses MobileRemoveDeviceId::setCredentials()
     * @uses MobileRemoveDeviceId::setDeviceId()
     * @param int $deviceOs
     * @param \StructType\ApiCredentials $credentials
     * @param string $deviceId
     */
    public function __construct($deviceOs = null, \StructType\ApiCredentials $credentials = null, $deviceId = null)
    {
        $this
            ->setDeviceOs($deviceOs)
            ->setCredentials($credentials)
            ->setDeviceId($deviceId);
    }
    /**
     * Get deviceOs value
     * @return int
     */
    public function getDeviceOs()
    {
        return $this->deviceOs;
    }
    /**
     * Set deviceOs value
     * @param int $deviceOs
     * @return \StructType\MobileRemoveDeviceId
     */
    public function setDeviceOs($deviceOs = null)
    {
        // validation for constraint: int
        if (!is_null($deviceOs) && !(is_int($deviceOs) || ctype_digit($deviceOs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceOs, true), gettype($deviceOs)), __LINE__);
        }
        $this->deviceOs = $deviceOs;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\MobileRemoveDeviceId
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get deviceId value
     * @return string|null
     */
    public function getDeviceId()
    {
        return $this->deviceId;
    }
    /**
     * Set deviceId value
     * @param string $deviceId
     * @return \StructType\MobileRemoveDeviceId
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceId) && !is_string($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->deviceId = $deviceId;
        return $this;
    }
}
