<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lead StructType
 * @subpackage Structs
 */
class Lead extends AbstractStructBase
{
    /**
     * The HowDidYouFindUsId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $HowDidYouFindUsId;
    /**
     * The NumberOfEmployeesId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $NumberOfEmployeesId;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtraInfo;
    /**
     * The LEA_actie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LEA_actie;
    /**
     * The LEA_actienav
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LEA_actienav;
    /**
     * The LEA_groep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LEA_groep;
    /**
     * The LEA_toegewezenaan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LEA_toegewezenaan;
    /**
     * Constructor method for Lead
     * @uses Lead::setHowDidYouFindUsId()
     * @uses Lead::setNumberOfEmployeesId()
     * @uses Lead::setSubject()
     * @uses Lead::setExtraInfo()
     * @uses Lead::setLEA_actie()
     * @uses Lead::setLEA_actienav()
     * @uses Lead::setLEA_groep()
     * @uses Lead::setLEA_toegewezenaan()
     * @param string $howDidYouFindUsId
     * @param string $numberOfEmployeesId
     * @param string $subject
     * @param string $extraInfo
     * @param string $lEA_actie
     * @param string $lEA_actienav
     * @param string $lEA_groep
     * @param string $lEA_toegewezenaan
     */
    public function __construct($howDidYouFindUsId = null, $numberOfEmployeesId = null, $subject = null, $extraInfo = null, $lEA_actie = null, $lEA_actienav = null, $lEA_groep = null, $lEA_toegewezenaan = null)
    {
        $this
            ->setHowDidYouFindUsId($howDidYouFindUsId)
            ->setNumberOfEmployeesId($numberOfEmployeesId)
            ->setSubject($subject)
            ->setExtraInfo($extraInfo)
            ->setLEA_actie($lEA_actie)
            ->setLEA_actienav($lEA_actienav)
            ->setLEA_groep($lEA_groep)
            ->setLEA_toegewezenaan($lEA_toegewezenaan);
    }
    /**
     * Get HowDidYouFindUsId value
     * @return string
     */
    public function getHowDidYouFindUsId()
    {
        return $this->HowDidYouFindUsId;
    }
    /**
     * Set HowDidYouFindUsId value
     * @param string $howDidYouFindUsId
     * @return \StructType\Lead
     */
    public function setHowDidYouFindUsId($howDidYouFindUsId = null)
    {
        // validation for constraint: string
        if (!is_null($howDidYouFindUsId) && !is_string($howDidYouFindUsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($howDidYouFindUsId, true), gettype($howDidYouFindUsId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($howDidYouFindUsId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $howDidYouFindUsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($howDidYouFindUsId, true)), __LINE__);
        }
        $this->HowDidYouFindUsId = $howDidYouFindUsId;
        return $this;
    }
    /**
     * Get NumberOfEmployeesId value
     * @return string
     */
    public function getNumberOfEmployeesId()
    {
        return $this->NumberOfEmployeesId;
    }
    /**
     * Set NumberOfEmployeesId value
     * @param string $numberOfEmployeesId
     * @return \StructType\Lead
     */
    public function setNumberOfEmployeesId($numberOfEmployeesId = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfEmployeesId) && !is_string($numberOfEmployeesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOfEmployeesId, true), gettype($numberOfEmployeesId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($numberOfEmployeesId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $numberOfEmployeesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($numberOfEmployeesId, true)), __LINE__);
        }
        $this->NumberOfEmployeesId = $numberOfEmployeesId;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\Lead
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get ExtraInfo value
     * @return string|null
     */
    public function getExtraInfo()
    {
        return $this->ExtraInfo;
    }
    /**
     * Set ExtraInfo value
     * @param string $extraInfo
     * @return \StructType\Lead
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        $this->ExtraInfo = $extraInfo;
        return $this;
    }
    /**
     * Get LEA_actie value
     * @return string|null
     */
    public function getLEA_actie()
    {
        return $this->LEA_actie;
    }
    /**
     * Set LEA_actie value
     * @param string $lEA_actie
     * @return \StructType\Lead
     */
    public function setLEA_actie($lEA_actie = null)
    {
        // validation for constraint: string
        if (!is_null($lEA_actie) && !is_string($lEA_actie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lEA_actie, true), gettype($lEA_actie)), __LINE__);
        }
        $this->LEA_actie = $lEA_actie;
        return $this;
    }
    /**
     * Get LEA_actienav value
     * @return string|null
     */
    public function getLEA_actienav()
    {
        return $this->LEA_actienav;
    }
    /**
     * Set LEA_actienav value
     * @param string $lEA_actienav
     * @return \StructType\Lead
     */
    public function setLEA_actienav($lEA_actienav = null)
    {
        // validation for constraint: string
        if (!is_null($lEA_actienav) && !is_string($lEA_actienav)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lEA_actienav, true), gettype($lEA_actienav)), __LINE__);
        }
        $this->LEA_actienav = $lEA_actienav;
        return $this;
    }
    /**
     * Get LEA_groep value
     * @return string|null
     */
    public function getLEA_groep()
    {
        return $this->LEA_groep;
    }
    /**
     * Set LEA_groep value
     * @param string $lEA_groep
     * @return \StructType\Lead
     */
    public function setLEA_groep($lEA_groep = null)
    {
        // validation for constraint: string
        if (!is_null($lEA_groep) && !is_string($lEA_groep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lEA_groep, true), gettype($lEA_groep)), __LINE__);
        }
        $this->LEA_groep = $lEA_groep;
        return $this;
    }
    /**
     * Get LEA_toegewezenaan value
     * @return string|null
     */
    public function getLEA_toegewezenaan()
    {
        return $this->LEA_toegewezenaan;
    }
    /**
     * Set LEA_toegewezenaan value
     * @param string $lEA_toegewezenaan
     * @return \StructType\Lead
     */
    public function setLEA_toegewezenaan($lEA_toegewezenaan = null)
    {
        // validation for constraint: string
        if (!is_null($lEA_toegewezenaan) && !is_string($lEA_toegewezenaan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lEA_toegewezenaan, true), gettype($lEA_toegewezenaan)), __LINE__);
        }
        $this->LEA_toegewezenaan = $lEA_toegewezenaan;
        return $this;
    }
}
