<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Database StructType
 * @subpackage Structs
 */
class Database extends AbstractStructBase
{
    /**
     * The ContractOwnerApiKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ContractOwnerApiKey;
    /**
     * The ProcessOwnerApiKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ProcessOwnerApiKey;
    /**
     * The LeadGeneratorApiKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $LeadGeneratorApiKey;
    /**
     * The DatabaseId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $DatabaseId;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $UserId;
    /**
     * The NumberOfLicenses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfLicenses;
    /**
     * The SourceDatabaseId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $SourceDatabaseId;
    /**
     * The CopyUsers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CopyUsers;
    /**
     * The ConformationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConformationCode;
    /**
     * Constructor method for Database
     * @uses Database::setContractOwnerApiKey()
     * @uses Database::setProcessOwnerApiKey()
     * @uses Database::setLeadGeneratorApiKey()
     * @uses Database::setDatabaseId()
     * @uses Database::setUserId()
     * @uses Database::setNumberOfLicenses()
     * @uses Database::setSourceDatabaseId()
     * @uses Database::setCopyUsers()
     * @uses Database::setConformationCode()
     * @param string $contractOwnerApiKey
     * @param string $processOwnerApiKey
     * @param string $leadGeneratorApiKey
     * @param string $databaseId
     * @param string $userId
     * @param int $numberOfLicenses
     * @param string $sourceDatabaseId
     * @param bool $copyUsers
     * @param string $conformationCode
     */
    public function __construct($contractOwnerApiKey = null, $processOwnerApiKey = null, $leadGeneratorApiKey = null, $databaseId = null, $userId = null, $numberOfLicenses = null, $sourceDatabaseId = null, $copyUsers = null, $conformationCode = null)
    {
        $this
            ->setContractOwnerApiKey($contractOwnerApiKey)
            ->setProcessOwnerApiKey($processOwnerApiKey)
            ->setLeadGeneratorApiKey($leadGeneratorApiKey)
            ->setDatabaseId($databaseId)
            ->setUserId($userId)
            ->setNumberOfLicenses($numberOfLicenses)
            ->setSourceDatabaseId($sourceDatabaseId)
            ->setCopyUsers($copyUsers)
            ->setConformationCode($conformationCode);
    }
    /**
     * Get ContractOwnerApiKey value
     * @return string
     */
    public function getContractOwnerApiKey()
    {
        return $this->ContractOwnerApiKey;
    }
    /**
     * Set ContractOwnerApiKey value
     * @param string $contractOwnerApiKey
     * @return \StructType\Database
     */
    public function setContractOwnerApiKey($contractOwnerApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($contractOwnerApiKey) && !is_string($contractOwnerApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractOwnerApiKey, true), gettype($contractOwnerApiKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($contractOwnerApiKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $contractOwnerApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($contractOwnerApiKey, true)), __LINE__);
        }
        $this->ContractOwnerApiKey = $contractOwnerApiKey;
        return $this;
    }
    /**
     * Get ProcessOwnerApiKey value
     * @return string
     */
    public function getProcessOwnerApiKey()
    {
        return $this->ProcessOwnerApiKey;
    }
    /**
     * Set ProcessOwnerApiKey value
     * @param string $processOwnerApiKey
     * @return \StructType\Database
     */
    public function setProcessOwnerApiKey($processOwnerApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($processOwnerApiKey) && !is_string($processOwnerApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processOwnerApiKey, true), gettype($processOwnerApiKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($processOwnerApiKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $processOwnerApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($processOwnerApiKey, true)), __LINE__);
        }
        $this->ProcessOwnerApiKey = $processOwnerApiKey;
        return $this;
    }
    /**
     * Get LeadGeneratorApiKey value
     * @return string
     */
    public function getLeadGeneratorApiKey()
    {
        return $this->LeadGeneratorApiKey;
    }
    /**
     * Set LeadGeneratorApiKey value
     * @param string $leadGeneratorApiKey
     * @return \StructType\Database
     */
    public function setLeadGeneratorApiKey($leadGeneratorApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($leadGeneratorApiKey) && !is_string($leadGeneratorApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadGeneratorApiKey, true), gettype($leadGeneratorApiKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($leadGeneratorApiKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $leadGeneratorApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($leadGeneratorApiKey, true)), __LINE__);
        }
        $this->LeadGeneratorApiKey = $leadGeneratorApiKey;
        return $this;
    }
    /**
     * Get DatabaseId value
     * @return string
     */
    public function getDatabaseId()
    {
        return $this->DatabaseId;
    }
    /**
     * Set DatabaseId value
     * @param string $databaseId
     * @return \StructType\Database
     */
    public function setDatabaseId($databaseId = null)
    {
        // validation for constraint: string
        if (!is_null($databaseId) && !is_string($databaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($databaseId, true), gettype($databaseId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($databaseId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $databaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($databaseId, true)), __LINE__);
        }
        $this->DatabaseId = $databaseId;
        return $this;
    }
    /**
     * Get UserId value
     * @return string
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \StructType\Database
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get NumberOfLicenses value
     * @return int
     */
    public function getNumberOfLicenses()
    {
        return $this->NumberOfLicenses;
    }
    /**
     * Set NumberOfLicenses value
     * @param int $numberOfLicenses
     * @return \StructType\Database
     */
    public function setNumberOfLicenses($numberOfLicenses = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfLicenses) && !(is_int($numberOfLicenses) || ctype_digit($numberOfLicenses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfLicenses, true), gettype($numberOfLicenses)), __LINE__);
        }
        $this->NumberOfLicenses = $numberOfLicenses;
        return $this;
    }
    /**
     * Get SourceDatabaseId value
     * @return string
     */
    public function getSourceDatabaseId()
    {
        return $this->SourceDatabaseId;
    }
    /**
     * Set SourceDatabaseId value
     * @param string $sourceDatabaseId
     * @return \StructType\Database
     */
    public function setSourceDatabaseId($sourceDatabaseId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceDatabaseId) && !is_string($sourceDatabaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceDatabaseId, true), gettype($sourceDatabaseId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($sourceDatabaseId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $sourceDatabaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($sourceDatabaseId, true)), __LINE__);
        }
        $this->SourceDatabaseId = $sourceDatabaseId;
        return $this;
    }
    /**
     * Get CopyUsers value
     * @return bool
     */
    public function getCopyUsers()
    {
        return $this->CopyUsers;
    }
    /**
     * Set CopyUsers value
     * @param bool $copyUsers
     * @return \StructType\Database
     */
    public function setCopyUsers($copyUsers = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyUsers) && !is_bool($copyUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyUsers, true), gettype($copyUsers)), __LINE__);
        }
        $this->CopyUsers = $copyUsers;
        return $this;
    }
    /**
     * Get ConformationCode value
     * @return string|null
     */
    public function getConformationCode()
    {
        return $this->ConformationCode;
    }
    /**
     * Set ConformationCode value
     * @param string $conformationCode
     * @return \StructType\Database
     */
    public function setConformationCode($conformationCode = null)
    {
        // validation for constraint: string
        if (!is_null($conformationCode) && !is_string($conformationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conformationCode, true), gettype($conformationCode)), __LINE__);
        }
        $this->ConformationCode = $conformationCode;
        return $this;
    }
}
