<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateDatabaseData StructType
 * @subpackage Structs
 */
class CreateDatabaseData extends AbstractStructBase
{
    /**
     * The DatabaseData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Database
     */
    public $DatabaseData;
    /**
     * The OrganisationData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Organisation
     */
    public $OrganisationData;
    /**
     * The FirstUserPersonData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Person
     */
    public $FirstUserPersonData;
    /**
     * The FirstUserEmployeeData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Employee
     */
    public $FirstUserEmployeeData;
    /**
     * The SlaGeneralContactPersonData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Person
     */
    public $SlaGeneralContactPersonData;
    /**
     * The SlaGeneralContactEmployeeData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Employee
     */
    public $SlaGeneralContactEmployeeData;
    /**
     * The SlaFinancialContactPersonData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Person
     */
    public $SlaFinancialContactPersonData;
    /**
     * The SlaFinancialContactEmployeeData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Employee
     */
    public $SlaFinancialContactEmployeeData;
    /**
     * The SlaTechnicalContactPersonData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Person
     */
    public $SlaTechnicalContactPersonData;
    /**
     * The SlaTechnicalContactEmployeeData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Employee
     */
    public $SlaTechnicalContactEmployeeData;
    /**
     * The LeadData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Lead
     */
    public $LeadData;
    /**
     * The WorkflowData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Workflow
     */
    public $WorkflowData;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfParameter
     */
    public $Parameters;
    /**
     * Constructor method for CreateDatabaseData
     * @uses CreateDatabaseData::setDatabaseData()
     * @uses CreateDatabaseData::setOrganisationData()
     * @uses CreateDatabaseData::setFirstUserPersonData()
     * @uses CreateDatabaseData::setFirstUserEmployeeData()
     * @uses CreateDatabaseData::setSlaGeneralContactPersonData()
     * @uses CreateDatabaseData::setSlaGeneralContactEmployeeData()
     * @uses CreateDatabaseData::setSlaFinancialContactPersonData()
     * @uses CreateDatabaseData::setSlaFinancialContactEmployeeData()
     * @uses CreateDatabaseData::setSlaTechnicalContactPersonData()
     * @uses CreateDatabaseData::setSlaTechnicalContactEmployeeData()
     * @uses CreateDatabaseData::setLeadData()
     * @uses CreateDatabaseData::setWorkflowData()
     * @uses CreateDatabaseData::setParameters()
     * @param \StructType\Database $databaseData
     * @param \StructType\Organisation $organisationData
     * @param \StructType\Person $firstUserPersonData
     * @param \StructType\Employee $firstUserEmployeeData
     * @param \StructType\Person $slaGeneralContactPersonData
     * @param \StructType\Employee $slaGeneralContactEmployeeData
     * @param \StructType\Person $slaFinancialContactPersonData
     * @param \StructType\Employee $slaFinancialContactEmployeeData
     * @param \StructType\Person $slaTechnicalContactPersonData
     * @param \StructType\Employee $slaTechnicalContactEmployeeData
     * @param \StructType\Lead $leadData
     * @param \StructType\Workflow $workflowData
     * @param \ArrayType\ArrayOfParameter $parameters
     */
    public function __construct(\StructType\Database $databaseData = null, \StructType\Organisation $organisationData = null, \StructType\Person $firstUserPersonData = null, \StructType\Employee $firstUserEmployeeData = null, \StructType\Person $slaGeneralContactPersonData = null, \StructType\Employee $slaGeneralContactEmployeeData = null, \StructType\Person $slaFinancialContactPersonData = null, \StructType\Employee $slaFinancialContactEmployeeData = null, \StructType\Person $slaTechnicalContactPersonData = null, \StructType\Employee $slaTechnicalContactEmployeeData = null, \StructType\Lead $leadData = null, \StructType\Workflow $workflowData = null, \ArrayType\ArrayOfParameter $parameters = null)
    {
        $this
            ->setDatabaseData($databaseData)
            ->setOrganisationData($organisationData)
            ->setFirstUserPersonData($firstUserPersonData)
            ->setFirstUserEmployeeData($firstUserEmployeeData)
            ->setSlaGeneralContactPersonData($slaGeneralContactPersonData)
            ->setSlaGeneralContactEmployeeData($slaGeneralContactEmployeeData)
            ->setSlaFinancialContactPersonData($slaFinancialContactPersonData)
            ->setSlaFinancialContactEmployeeData($slaFinancialContactEmployeeData)
            ->setSlaTechnicalContactPersonData($slaTechnicalContactPersonData)
            ->setSlaTechnicalContactEmployeeData($slaTechnicalContactEmployeeData)
            ->setLeadData($leadData)
            ->setWorkflowData($workflowData)
            ->setParameters($parameters);
    }
    /**
     * Get DatabaseData value
     * @return \StructType\Database
     */
    public function getDatabaseData()
    {
        return $this->DatabaseData;
    }
    /**
     * Set DatabaseData value
     * @param \StructType\Database $databaseData
     * @return \StructType\CreateDatabaseData
     */
    public function setDatabaseData(\StructType\Database $databaseData = null)
    {
        $this->DatabaseData = $databaseData;
        return $this;
    }
    /**
     * Get OrganisationData value
     * @return \StructType\Organisation
     */
    public function getOrganisationData()
    {
        return $this->OrganisationData;
    }
    /**
     * Set OrganisationData value
     * @param \StructType\Organisation $organisationData
     * @return \StructType\CreateDatabaseData
     */
    public function setOrganisationData(\StructType\Organisation $organisationData = null)
    {
        $this->OrganisationData = $organisationData;
        return $this;
    }
    /**
     * Get FirstUserPersonData value
     * @return \StructType\Person
     */
    public function getFirstUserPersonData()
    {
        return $this->FirstUserPersonData;
    }
    /**
     * Set FirstUserPersonData value
     * @param \StructType\Person $firstUserPersonData
     * @return \StructType\CreateDatabaseData
     */
    public function setFirstUserPersonData(\StructType\Person $firstUserPersonData = null)
    {
        $this->FirstUserPersonData = $firstUserPersonData;
        return $this;
    }
    /**
     * Get FirstUserEmployeeData value
     * @return \StructType\Employee
     */
    public function getFirstUserEmployeeData()
    {
        return $this->FirstUserEmployeeData;
    }
    /**
     * Set FirstUserEmployeeData value
     * @param \StructType\Employee $firstUserEmployeeData
     * @return \StructType\CreateDatabaseData
     */
    public function setFirstUserEmployeeData(\StructType\Employee $firstUserEmployeeData = null)
    {
        $this->FirstUserEmployeeData = $firstUserEmployeeData;
        return $this;
    }
    /**
     * Get SlaGeneralContactPersonData value
     * @return \StructType\Person
     */
    public function getSlaGeneralContactPersonData()
    {
        return $this->SlaGeneralContactPersonData;
    }
    /**
     * Set SlaGeneralContactPersonData value
     * @param \StructType\Person $slaGeneralContactPersonData
     * @return \StructType\CreateDatabaseData
     */
    public function setSlaGeneralContactPersonData(\StructType\Person $slaGeneralContactPersonData = null)
    {
        $this->SlaGeneralContactPersonData = $slaGeneralContactPersonData;
        return $this;
    }
    /**
     * Get SlaGeneralContactEmployeeData value
     * @return \StructType\Employee
     */
    public function getSlaGeneralContactEmployeeData()
    {
        return $this->SlaGeneralContactEmployeeData;
    }
    /**
     * Set SlaGeneralContactEmployeeData value
     * @param \StructType\Employee $slaGeneralContactEmployeeData
     * @return \StructType\CreateDatabaseData
     */
    public function setSlaGeneralContactEmployeeData(\StructType\Employee $slaGeneralContactEmployeeData = null)
    {
        $this->SlaGeneralContactEmployeeData = $slaGeneralContactEmployeeData;
        return $this;
    }
    /**
     * Get SlaFinancialContactPersonData value
     * @return \StructType\Person
     */
    public function getSlaFinancialContactPersonData()
    {
        return $this->SlaFinancialContactPersonData;
    }
    /**
     * Set SlaFinancialContactPersonData value
     * @param \StructType\Person $slaFinancialContactPersonData
     * @return \StructType\CreateDatabaseData
     */
    public function setSlaFinancialContactPersonData(\StructType\Person $slaFinancialContactPersonData = null)
    {
        $this->SlaFinancialContactPersonData = $slaFinancialContactPersonData;
        return $this;
    }
    /**
     * Get SlaFinancialContactEmployeeData value
     * @return \StructType\Employee
     */
    public function getSlaFinancialContactEmployeeData()
    {
        return $this->SlaFinancialContactEmployeeData;
    }
    /**
     * Set SlaFinancialContactEmployeeData value
     * @param \StructType\Employee $slaFinancialContactEmployeeData
     * @return \StructType\CreateDatabaseData
     */
    public function setSlaFinancialContactEmployeeData(\StructType\Employee $slaFinancialContactEmployeeData = null)
    {
        $this->SlaFinancialContactEmployeeData = $slaFinancialContactEmployeeData;
        return $this;
    }
    /**
     * Get SlaTechnicalContactPersonData value
     * @return \StructType\Person
     */
    public function getSlaTechnicalContactPersonData()
    {
        return $this->SlaTechnicalContactPersonData;
    }
    /**
     * Set SlaTechnicalContactPersonData value
     * @param \StructType\Person $slaTechnicalContactPersonData
     * @return \StructType\CreateDatabaseData
     */
    public function setSlaTechnicalContactPersonData(\StructType\Person $slaTechnicalContactPersonData = null)
    {
        $this->SlaTechnicalContactPersonData = $slaTechnicalContactPersonData;
        return $this;
    }
    /**
     * Get SlaTechnicalContactEmployeeData value
     * @return \StructType\Employee
     */
    public function getSlaTechnicalContactEmployeeData()
    {
        return $this->SlaTechnicalContactEmployeeData;
    }
    /**
     * Set SlaTechnicalContactEmployeeData value
     * @param \StructType\Employee $slaTechnicalContactEmployeeData
     * @return \StructType\CreateDatabaseData
     */
    public function setSlaTechnicalContactEmployeeData(\StructType\Employee $slaTechnicalContactEmployeeData = null)
    {
        $this->SlaTechnicalContactEmployeeData = $slaTechnicalContactEmployeeData;
        return $this;
    }
    /**
     * Get LeadData value
     * @return \StructType\Lead
     */
    public function getLeadData()
    {
        return $this->LeadData;
    }
    /**
     * Set LeadData value
     * @param \StructType\Lead $leadData
     * @return \StructType\CreateDatabaseData
     */
    public function setLeadData(\StructType\Lead $leadData = null)
    {
        $this->LeadData = $leadData;
        return $this;
    }
    /**
     * Get WorkflowData value
     * @return \StructType\Workflow
     */
    public function getWorkflowData()
    {
        return $this->WorkflowData;
    }
    /**
     * Set WorkflowData value
     * @param \StructType\Workflow $workflowData
     * @return \StructType\CreateDatabaseData
     */
    public function setWorkflowData(\StructType\Workflow $workflowData = null)
    {
        $this->WorkflowData = $workflowData;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \ArrayType\ArrayOfParameter|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \ArrayType\ArrayOfParameter $parameters
     * @return \StructType\CreateDatabaseData
     */
    public function setParameters(\ArrayType\ArrayOfParameter $parameters = null)
    {
        $this->Parameters = $parameters;
        return $this;
    }
}
